package org.mule.weave.v2.module.dwb.reader.indexed

import java.time.LocalDate

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.LocalDateValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryLocalDate(token: Array[Long], input: BinaryParserInput) extends LocalDateValue {
  private lazy val offset: Long = DwTokenHelper.getOffset(token)
  private lazy val value: LocalDate = {
    val stream = input.dataInputStream
    input.seekableStream.seek(offset)
    val epochDay = stream.readLong()
    LocalDate.ofEpochDay(epochDay)
  }

  override def evaluate(implicit ctx: EvaluationContext): T = value
  override def location(): Location = new BinaryLocation(offset)
}
