package org.mule.weave.v2.module.dwb.reader.indexed

import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.module.dwb.BinaryLocation
import org.mule.weave.v2.module.dwb.DwTokenHelper
import org.mule.weave.v2.parser.location.Location

class WeaveBinaryBlob(tokenIndex: Long, token: Array[Long], input: BinaryParserInput) extends BinaryValue {
  private val offset = DwTokenHelper.getOffset(token)
  private val length = DwTokenHelper.getValueLength(token)

  private var _valueType: Type = _
  private var _schema: Option[Schema] = _
  private var value: SeekableStream = _

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    if (_schema == null) {
      if (DwTokenHelper.hasSchemaProps(token)) {
        val schemaOffset = offset + length
        val schema = WeaveBinaryValue.readSchema(input, tokenIndex, schemaOffset)
        _schema = Some(schema)
      } else {
        _schema = None
      }
    }
    _schema
  }

  override def evaluate(implicit ctx: EvaluationContext): SeekableStream = {
    if (value == null) {
      //TODO: improve this
      val stream = input.streamSpinOff()
      stream.seek(offset)
      val bytes = new Array[Byte](length.toInt)
      stream.read(bytes)
      stream.close()
      value = SeekableStream(bytes)
    }
    value
  }

  override def location(): Location = new BinaryLocation(offset)
}

