package org.mule.weave.v2.debugger.commands

import org.mule.weave.v2.debugger.WeaveBreakpoint
import org.mule.weave.v2.debugger.WeaveExceptionBreakpoint
import org.mule.weave.v2.debugger.event.ClientInitializedEvent
import org.mule.weave.v2.debugger.event.DebuggerEvent

class InitializeSessionCommand(initialBreakpoints: Array[WeaveBreakpoint], initialExceptionBreakpoints: Array[WeaveExceptionBreakpoint]) extends DebuggerCommand {
  override def call(debuggerContext: WeaveDebuggerCommandInterpreter): Option[DebuggerEvent] = {
    initialBreakpoints.foreach((breakpoint: WeaveBreakpoint) => {
      debuggerContext.addBreakpoint(breakpoint)
    })
    debuggerContext.addExceptionBreakpoint(initialExceptionBreakpoints)
    debuggerContext.initSession()
    Some(ClientInitializedEvent())
  }
}
