package org.mule.weave.v2.debugger

@SerialVersionUID(1000L)
case class WeaveBreakpoint(lineNumber: Int, nameIdentifier: String, column: Int = WeaveBreakpoint.ANY_COLUMN, condition: String = null) extends Serializable {

  override def toString = s"Breakpoint($lineNumber, $column)"

  def canEqual(other: Any): Boolean = other.isInstanceOf[WeaveBreakpoint]

  override def equals(other: Any): Boolean = other match {
    case that: WeaveBreakpoint =>
      (that canEqual this) &&
        lineNumber == that.lineNumber &&
        column == that.column
    case _ => false
  }

  override def hashCode(): Int = {
    val state = Seq(lineNumber, column)
    state.map(_.hashCode()).foldLeft(0)((a, b) => 31 * a + b)
  }
}

object WeaveBreakpoint {
  val ANY_COLUMN: Int = -1
}