/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import com.mulesoft.weave.docs.DocTemplateBundle;
import com.mulesoft.weave.docs.DocTemplateBundles;
import com.mulesoft.weave.docs.WeaveDocsGenerator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.weave.maven.plugin.WeaveDocsMojo;

@Mojo(name="generate-docs", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
@Execute(goal="generate-docs")
public class WeaveGenerateDocsMojo
extends WeaveDocsMojo {
    private static final Pattern VERSION_PATTER = Pattern.compile("([1-9]\\d*)\\.(\\d+)\\.(\\d+)(?:-([a-zA-Z0-9]+))?");
    private static final String WLANG_GROUP_ID = "org.mule.weave";
    private static final String WLANG_ARTIFACT_ID = "wlang";

    @Override
    protected void doExecute() throws MojoExecutionException {
        try {
            File canonicalFile = this.config.getOutput().getCanonicalFile();
            this.getLog().info((CharSequence)String.format("Generating docs at: %s", canonicalFile));
            if (!this.config.getOutput().exists()) {
                this.config.getOutput().mkdirs();
            }
            HashMap<String, String> docsConfiguration = new HashMap<String, String>();
            Optional<Artifact> maybeWlangArtifact = this.project.getArtifacts().stream().filter(artifact -> WLANG_GROUP_ID.equals(artifact.getGroupId()) && WLANG_ARTIFACT_ID.equals(artifact.getArtifactId())).findFirst();
            if (maybeWlangArtifact.isPresent()) {
                Artifact wlangArtifact = maybeWlangArtifact.get();
                String wlangVersion = wlangArtifact.getBaseVersion();
                Matcher matcher = VERSION_PATTER.matcher(wlangVersion);
                if (matcher.matches()) {
                    String major = matcher.group(1);
                    String minor = matcher.group(2);
                    docsConfiguration.put(WeaveDocsGenerator.MIN_DW_VERSION(), String.format("%s.%s", major, minor));
                } else {
                    this.getLog().warn((CharSequence)String.format("Invalid wlang version: %s", wlangVersion));
                }
            } else {
                this.getLog().warn((CharSequence)"Enable to find wlang artifact.");
            }
            DocTemplateBundle docTemplateBundleOption = DocTemplateBundles.templateByName((String)this.config.getTemplate(), (DocTemplateBundle)DocTemplateBundles.exchangeMarkdown());
            if (this.config.getHomePage() != null) {
                docsConfiguration.put(WeaveDocsGenerator.MODULE_DOC_PATH(), this.config.getHomePage().getPath());
            }
            WeaveDocsGenerator.generate((DocTemplateBundle)docTemplateBundleOption, (File)this.sourceFolder, (File)canonicalFile, docsConfiguration);
            this.getLog().info((CharSequence)String.format("Generated docs at: %s", canonicalFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while resolving.", (Exception)e);
        }
    }
}

