/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.FileUtils;
import org.mule.weave.maven.plugin.AbstractWeaveMojo;
import org.mule.weave.v2.inspector.Inspector;
import org.mule.weave.v2.inspector.NoInspector$;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, executionStrategy="always")
@Execute(goal="compile")
public class WeaveCompileMojo
extends AbstractWeaveMojo {
    private static final String DW_EXTENSION = "dwl";

    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)String.format("Start Compiling DataWeave: %s", this.project.getName()));
        int numberOfError = this.validate(this.sourceFolder, "");
        if (numberOfError > 0) {
            throw new MojoFailureException(String.format("Compilation failure %s errors found.", numberOfError));
        }
        this.getLog().info((CharSequence)String.format("DataWeave %s successfully compiled", this.project.getName()));
    }

    private int validate(File sourceDir, String name) {
        File[] child;
        int errors = 0;
        for (File file : child = Optional.ofNullable(sourceDir.listFiles()).orElse(new File[0])) {
            this.getLog().info((CharSequence)String.format("Compiling %s", file.getAbsolutePath()));
            if (this.isDWFile(file)) {
                String basename = FileUtils.basename((String)file.getName());
                errors += this.parse(NameIdentifier.apply((String)this.nameIdentifier(name, basename), (Option)Option.empty()), file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.validate(file, this.nameIdentifier(name, file.getName()));
        }
        return errors;
    }

    private boolean isDWFile(File file) {
        return Optional.ofNullable(file).map(f -> DW_EXTENSION.equals(FileUtils.extension((String)f.getName()))).orElse(false);
    }

    private String nameIdentifier(String name, String moduleName) {
        if (name.isEmpty()) {
            return moduleName;
        }
        return name + NameIdentifier.SEPARATOR() + moduleName;
    }

    private int parse(NameIdentifier identifier, File file) {
        DocumentParser documentParser = new DocumentParser(15, (Inspector)NoInspector$.MODULE$);
        ParsingContext parsingContext = ParsingContextFactory.createParsingContext((NameIdentifier)identifier);
        PhaseResult parseResult = documentParser.parse(WeaveResourceFactory.fromFile((File)file), parsingContext);
        Iterator errors = parseResult.messages().errorMessages().toIterator();
        while (errors.hasNext()) {
            Tuple2 next = (Tuple2)errors.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            this.getLog().error((CharSequence)String.format("%s at %s ", ((Message)next._2).message(), weaveLocation.locationString()));
            try {
                this.getLog().error((CharSequence)String.format("%s: [%s, %s]", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column()));
            }
            catch (IOException iOException) {}
        }
        Iterator warnings = parseResult.messages().warningMessages().toIterator();
        while (warnings.hasNext()) {
            Tuple2 next = (Tuple2)warnings.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            this.getLog().warn((CharSequence)String.format("%s at %s", ((Message)next._2).message(), weaveLocation.locationString()));
            try {
                this.getLog().warn((CharSequence)String.format("%s: [%s, %s]", file.getCanonicalPath(), weaveLocation.startPosition().line(), weaveLocation.startPosition().column()));
            }
            catch (IOException iOException) {}
        }
        return parseResult.errorMessages().length();
    }
}

