/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.docs;

import com.mulesoft.weave.docs.DocTemplate;
import com.mulesoft.weave.docs.DocTemplateBundle;
import com.mulesoft.weave.docs.PostProcessor;
import com.mulesoft.weave.docs.WeaveDocsTemplateRunner;
import com.mulesoft.weave.docs.WeaveFileHelper$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class WeaveDocsGenerator$ {
    public static WeaveDocsGenerator$ MODULE$;
    private final String MODULE_DOC_PATH;
    private final String MIN_DW_VERSION;

    static {
        new WeaveDocsGenerator$();
    }

    public String MODULE_DOC_PATH() {
        return this.MODULE_DOC_PATH;
    }

    public String MIN_DW_VERSION() {
        return this.MIN_DW_VERSION;
    }

    public void generate(DocTemplateBundle template, File resourceDirectory, File outputBaseDirectory, java.util.Map<String, String> configuration) {
        Option<DocTemplate> docTemplateIsDefined;
        File asciidocFolder = new File(outputBaseDirectory, template.targetFolder());
        asciidocFolder.mkdirs();
        Seq<File> dwScripts = WeaveFileHelper$.MODULE$.collectWeaveFiles(resourceDirectory, true);
        String basePath = resourceDirectory.getCanonicalPath();
        template.resources().foreach((Function1 & Serializable & scala.Serializable)resource -> {
            if (!new File(resourceDirectory, resource.name()).exists()) {
                return BoxesRunTime.boxToLong((long)Files.copy(resource.content(), new File(asciidocFolder, resource.name()).toPath(), new CopyOption[0]));
            }
            return BoxedUnit.UNIT;
        });
        Seq nameAndScripts = (Seq)dwScripts.map((Function1 & Serializable & scala.Serializable)script -> {
            String scriptPath = script.getCanonicalPath();
            String relativePath = scriptPath.substring(basePath.length() + 1, scriptPath.length() - ".wev".length());
            NameIdentifier nameIdentifier = NameIdentifierHelper$.MODULE$.fromWeaveFilePath(relativePath);
            AstNode scriptNode = WeaveFileHelper$.MODULE$.parse(nameIdentifier, (File)script);
            return new Tuple2((Object)nameIdentifier, (Object)scriptNode);
        }, Seq$.MODULE$.canBuildFrom());
        Seq mappings = (Seq)nameAndScripts.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)WeaveFileHelper$.MODULE$.isMapping((AstNode)m._2())));
        Seq modules = template.mappings().isDefined() ? (Seq)nameAndScripts.filterNot((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)WeaveFileHelper$.MODULE$.isMapping((AstNode)m._2()))) : nameAndScripts;
        modules.foreach((Function1 & Serializable & scala.Serializable)nameWithNode -> {
            WeaveDocsGenerator$.$anonfun$generate$5(template, asciidocFolder, nameWithNode);
            return BoxedUnit.UNIT;
        });
        if (mappings.nonEmpty() && template.mappings().isDefined()) {
            WeaveDocsTemplateRunner mappingsTemplateRunner = new WeaveDocsTemplateRunner((DocTemplate)template.mappings().get(), asciidocFolder);
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> mappingsTemplateRunner.generateMappingsDoc((Seq<Tuple2<NameIdentifier, AstNode>>)mappings));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new RuntimeException(new StringBuilder(38).append("Error :").append(exception.getMessage()).append(" while generating Mapping Docs.").toString(), exception);
            }
        }
        if ((docTemplateIsDefined = template.tableOfContent()).isDefined()) {
            File file;
            DocTemplate indexTemplate = (DocTemplate)docTemplateIsDefined.get();
            if (indexTemplate.targetFolder().isDefined()) {
                File folder = new File(asciidocFolder, (String)indexTemplate.targetFolder().get());
                folder.mkdirs();
                file = folder;
            } else {
                file = asciidocFolder;
            }
            File indexTargetFolder = file;
            WeaveDocsTemplateRunner indexTemplateRunner = new WeaveDocsTemplateRunner(indexTemplate, indexTargetFolder);
            String mappingsTemplateName = template.mappings().isDefined() ? ((DocTemplate)template.mappings().get()).outputFileNamePattern() : "mappings";
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> indexTemplateRunner.generateIndex((Seq<Tuple2<NameIdentifier, AstNode>>)nameAndScripts, mappingsTemplateName, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configuration).asScala()).toMap(Predef$.MODULE$.$conforms())));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw new RuntimeException(new StringBuilder(31).append("Error :").append(exception.getMessage()).append(" while generating Index.").toString(), exception);
            }
        }
        template.postProcessor().foreach((Function1 & Serializable & scala.Serializable)p -> {
            WeaveDocsGenerator$.$anonfun$generate$10(outputBaseDirectory, asciidocFolder, configuration, p);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generate$6(File asciidocFolder$1, NameIdentifier nameIdentifier$1, AstNode weaveNode$1, DocTemplate template) {
        WeaveDocsTemplateRunner templateRunner = new WeaveDocsTemplateRunner(template, asciidocFolder$1);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> templateRunner.generateDoc(nameIdentifier$1, weaveNode$1));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new RuntimeException(new StringBuilder(37).append("Exception while executing template = ").append(template.docResource().name()).toString(), exception);
        }
    }

    public static final /* synthetic */ void $anonfun$generate$5(DocTemplateBundle template$1, File asciidocFolder$1, Tuple2 nameWithNode) {
        Tuple2 tuple2 = nameWithNode;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        NameIdentifier nameIdentifier = (NameIdentifier)tuple2._1();
        AstNode weaveNode = (AstNode)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nameIdentifier, (Object)weaveNode);
        NameIdentifier nameIdentifier2 = (NameIdentifier)tuple22._1();
        AstNode weaveNode2 = (AstNode)tuple22._2();
        template$1.docGenerator().foreach((Function1 & Serializable & scala.Serializable)template -> {
            WeaveDocsGenerator$.$anonfun$generate$6(asciidocFolder$1, nameIdentifier2, weaveNode2, template);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generate$10(File outputBaseDirectory$1, File asciidocFolder$1, java.util.Map configuration$1, PostProcessor p) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> p.postExecute(outputBaseDirectory$1, asciidocFolder$1, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(configuration$1).asScala()).toMap(Predef$.MODULE$.$conforms())));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new RuntimeException(new StringBuilder(39).append("Error :").append(exception.getMessage()).append(" while executing post processor.").toString(), exception);
        }
    }

    private WeaveDocsGenerator$() {
        MODULE$ = this;
        this.MODULE_DOC_PATH = "moduleDocPath";
        this.MIN_DW_VERSION = "minDWVersion";
    }
}

