package org.mule.weave.v2.module.avro

import org.apache.avro.Conversion
import org.apache.avro.Conversions
import org.apache.avro.LogicalType
import org.apache.avro.Schema.Type
import org.apache.avro.data.TimeConversions
import org.apache.avro.generic.GenericFixed
import org.apache.avro.generic.GenericRecord

import java.nio.ByteBuffer

object ConversionFactory {

  val typeToClassMap = Map(
    Type.MAP -> classOf[GenericRecord],
    Type.RECORD -> classOf[GenericRecord],
    Type.INT -> classOf[java.lang.Integer],
    Type.FLOAT -> classOf[java.lang.Float],
    Type.LONG -> classOf[java.lang.Long],
    Type.DOUBLE -> classOf[java.lang.Double],
    Type.BOOLEAN -> classOf[java.lang.Boolean],
    Type.BYTES -> classOf[ByteBuffer],
    Type.FIXED -> classOf[GenericFixed],
    Type.STRING -> classOf[java.lang.String])

  def getConversion(logicalType: LogicalType): Option[Conversion[_]] = {
    if (logicalType == null) {
      None
    } else {
      logicalType.getName match {
        case "decimal"                => Some(new Conversions.DecimalConversion())
        case "date"                   => Some(new TimeConversions.DateConversion())
        case "time-millis"            => Some(new TimeConversions.TimeMillisConversion())
        case "time-micros"            => Some(new TimeConversions.TimeMicrosConversion())
        case "timestamp-millis"       => Some(new TimeConversions.TimestampMillisConversion())
        case "timestamp-micros"       => Some(new TimeConversions.TimestampMicrosConversion())
        case "local-timestamp-millis" => Some(new TimeConversions.LocalTimestampMillisConversion())
        case "local-timestamp-micros" => Some(new TimeConversions.LocalTimestampMicrosConversion())
        case "uuid"                   => Some(new Conversions.UUIDConversion())
        case _                        => None
      }
    }
  }

}
