package org.mule.weave.v2.module.avro.exception

import org.mule.weave.v2.model.types.Type
import org.mule.weave.v2.parser.location.Location

class UnableToConvertTypeException(weaveType: Type, actualClass: Class[_], expectedClass: Class[_], logicalType: String, val location: Location) extends AvroInvalidTypeException {
  override def message: String = s"Unable to convert `${weaveType.name}` to  `${logicalType}`. Expected type is `${expectedClass.getSimpleName}` but got `${actualClass.getSimpleName}"
}
