/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.schemadocs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SchemaDocsMain {
    public static final String BACKUP = ".bak";
    public static final String XSD = ".xsd";
    public static final String MULE = "mule";
    public static final String TAG = "tag";
    public static final String XSL_FILE = "rename-tag.xsl";
    public static final List TARGET_PATH = Arrays.asList("tools", "schemadocs", "target");
    public static final String[] BLOCKED = new String[]{"wssecurity"};
    protected final Log logger = LogFactory.getLog(this.getClass());

    public static void main(String[] args) throws IOException, TransformerException, ParserConfigurationException {
        if (null == args || args.length != 3) {
            throw new IllegalArgumentException("Needs 3 arguments: prefix, postfix and destination");
        }
        new SchemaDocsMain(args[0], args[1], args[2]);
    }

    public SchemaDocsMain(String prefix, String postfix, String normalizedPath) throws IOException, TransformerException, ParserConfigurationException {
        this.logger.info((Object)("Generating " + normalizedPath));
        this.logger.debug((Object)("prefix: " + prefix));
        this.logger.debug((Object)("postfix: " + postfix));
        File normalized = this.inTargetDir(normalizedPath);
        this.backup(normalized);
        InputStream xslSource = IOUtils.getResourceAsStream((String)XSL_FILE, this.getClass());
        if (null == xslSource) {
            throw new IllegalStateException("Cannot open rename-tag.xsl");
        }
        this.create(normalized, false);
        FileOutputStream out = new FileOutputStream(normalized);
        this.logger.debug((Object)("out: " + out));
        OutputStreamWriter outWriter = new OutputStreamWriter(out);
        IOUtils.copy((InputStream)IOUtils.getResourceAsStream((String)prefix, this.getClass()), (Writer)outWriter);
        outWriter.flush();
        this.processSchema(xslSource, out);
        out.flush();
        IOUtils.copy((InputStream)IOUtils.getResourceAsStream((String)postfix, this.getClass()), (Writer)outWriter);
        outWriter.close();
    }

    protected void create(File file, boolean dir) throws IOException {
        if (!file.getParentFile().exists()) {
            this.create(file.getParentFile(), true);
        }
        this.logger.debug((Object)("creating " + file));
        if (dir) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
    }

    protected File inTargetDir(String path) {
        if (path.startsWith(File.separator)) {
            return new File(path);
        }
        File dir = new File(".");
        Iterator dirs = TARGET_PATH.iterator();
        boolean foundPath = false;
        while (dirs.hasNext()) {
            File next = new File(dir, (String)dirs.next());
            if (next.exists()) {
                foundPath = true;
                dir = next;
                continue;
            }
            if (!foundPath) continue;
            throw new IllegalArgumentException("Could not find " + next + " while placing in target directory");
        }
        File target = new File(dir, path);
        this.logger.info((Object)("Target: " + target));
        return target;
    }

    protected void processSchema(InputStream xslSource, OutputStream out) throws TransformerException, IOException, ParserConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Templates template = factory.newTemplates(new StreamSource(xslSource));
        Transformer xformer = template.newTransformer();
        for (URL url : this.listSchema2()) {
            String tag = SchemaDocsMain.tagFromFileName(url.getFile());
            this.logger.info((Object)(tag + " : " + url));
            xformer.setParameter(TAG, tag);
            StreamSource source = new StreamSource(url.openStream());
            xformer.transform(source, new StreamResult(out));
            out.flush();
        }
    }

    protected static String tagFromFileName(String name) {
        String dropExtension = SchemaDocsMain.toLeftOf(name, ".", name);
        String dropSlash = SchemaDocsMain.toRightOf(dropExtension, "/", dropExtension, true);
        String dropBackslash = SchemaDocsMain.toRightOf(dropSlash, "\\", dropSlash, true);
        return SchemaDocsMain.toRightOf(dropBackslash, "-", MULE, false);
    }

    protected static String toRightOf(String text, String delim, String deflt, boolean far) {
        int index;
        int n = index = far ? text.lastIndexOf(delim) : text.indexOf(delim);
        if (index > -1) {
            return text.substring(index + 1);
        }
        return deflt;
    }

    protected static String toLeftOf(String text, String delim, String deflt) {
        int index = text.lastIndexOf(delim);
        if (index > -1) {
            return text.substring(0, index);
        }
        return deflt;
    }

    protected List listSchema1() throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
        Resource[] resources = resolver.getResources("**/META-INF/*.xsd");
        LinkedList<URL> list = new LinkedList<URL>();
        for (int i = 0; i < resources.length; ++i) {
            list.add(resources[i].getURL());
        }
        return list;
    }

    protected List listSchema2() throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        LinkedList files = new LinkedList();
        Enumeration<URL> resources = loader.getResources("META-INF");
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.startsWith(SchemaDocsMain.MULE) && name.endsWith(SchemaDocsMain.XSD)) {
                    for (int i = 0; i < BLOCKED.length; ++i) {
                        if (name.indexOf(BLOCKED[i]) <= -1) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            this.logger.debug((Object)("url: " + url));
            if (url.toString().startsWith("jar:")) {
                this.readFromJar(url, files);
                continue;
            }
            if (!"file".equals(url.getProtocol())) continue;
            this.readFromDirectory(new File(url.getFile()), files, filter);
        }
        return files;
    }

    protected void readFromDirectory(File dir, List files, FilenameFilter filter) throws MalformedURLException {
        String[] names = dir.list(filter);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            this.logger.debug((Object)("file: " + name));
            files.add(new File(dir, name).toURL());
        }
    }

    protected void readFromJar(URL jarUrl, List resources) throws IOException {
        JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
        Enumeration<JarEntry> entries = jarConnection.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = new File(entry.getName()).getName();
            if (!name.startsWith(MULE) || !name.endsWith(XSD)) continue;
            this.logger.debug((Object)("entry: " + entry));
            resources.add(new URL(jarUrl, entry.getName()));
        }
    }

    protected void backup(File file) throws IOException {
        if (file.exists()) {
            File backup = new File(file.getAbsoluteFile().getParent(), file.getName() + BACKUP);
            if (backup.exists()) {
                this.logger.debug((Object)("deleting " + backup.getCanonicalPath()));
                backup.delete();
            }
            this.logger.debug((Object)("renaming " + file.getCanonicalPath() + " to " + backup.getCanonicalPath()));
            file.renameTo(backup);
        }
    }
}

