/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.anttasks;

import java.io.File;
import java.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;

public class FileChecker
extends Task {
    private Location location;

    public FileChecker(Location location) {
        this.location = location;
    }

    public void checkFile(File file, String parameterName, boolean isDirectory, boolean needWrite) throws BuildException {
        if (file == null) {
            throw new BuildException(MessageFormat.format("No {0} specified", parameterName), this.getLocation());
        }
        if (!file.exists()) {
            throw new BuildException(MessageFormat.format("{0} \"{1}\" does not exist", parameterName, file), this.getLocation());
        }
        if (!file.canRead()) {
            throw new BuildException(MessageFormat.format("{0} \"{1}\" is not readable", parameterName, file), this.getLocation());
        }
        if (needWrite && !file.canWrite()) {
            throw new BuildException(MessageFormat.format("{0} \"{1}\" is not writable", parameterName, file), this.getLocation());
        }
        if (isDirectory) {
            if (!file.isDirectory()) {
                throw new BuildException(MessageFormat.format("{0} \"{1}\" is not a directory", parameterName, file), this.getLocation());
            }
        } else if (file.isDirectory()) {
            throw new BuildException(MessageFormat.format("{0} \"{1}\" is a directory", parameterName, file), this.getLocation());
        }
    }
}

