/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.DosFileAttributeView;
import java.util.Objects;

public class FileUtils {
    public static void markAsReadOnly(File file) throws IOException {
        Path filePath;
        FileStore fileStore;
        boolean succeeded = file.setReadOnly();
        if (!succeeded && (fileStore = Files.getFileStore(filePath = file.toPath())).supportsFileAttributeView(DosFileAttributeView.class)) {
            DosFileAttributeView fileAttributeView = Files.getFileAttributeView(filePath, DosFileAttributeView.class, new LinkOption[0]);
            fileAttributeView.setReadOnly(true);
        }
    }

    public static void checkReadOnly(File file) throws IOException {
        DosFileAttributeView fileAttributeView;
        Path repositoryPath = file.toPath();
        FileStore fileStore = Files.getFileStore(repositoryPath);
        if (fileStore.supportsFileAttributeView(DosFileAttributeView.class) && (fileAttributeView = Files.getFileAttributeView(repositoryPath, DosFileAttributeView.class, new LinkOption[0])).readAttributes().isReadOnly()) {
            throw new IOException("File is not writable");
        }
    }

    public static void copyDirectoryRecursively(File origin, File destination, CopyOption ... copyOption) throws IOException {
        if (!destination.exists()) {
            destination.mkdir();
        }
        for (String child : Objects.requireNonNull(origin.list())) {
            FileUtils.copyDirectory(new File(origin, child), new File(destination, child), copyOption);
        }
    }

    private static void copyDirectory(File origin, File destination, CopyOption ... copyOption) throws IOException {
        if (origin.isDirectory()) {
            FileUtils.copyDirectoryRecursively(origin, destination, copyOption);
        } else {
            Files.copy(origin.toPath(), destination.toPath(), copyOption);
        }
    }
}

