/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.validation.resolver.visitor;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.validation.resolver.model.DependenciesFilter;
import org.mule.tools.api.validation.resolver.model.ProjectDependencyNode;
import org.mule.tools.api.validation.resolver.visitor.DependencyNodeVisitor;

public abstract class AbstractArtifactVisitor
implements DependencyNodeVisitor {
    private Supplier<DependencyNodeVisitor> childVisitor;
    protected Set<ArtifactCoordinates> collectedDependencies = Sets.newHashSet();
    protected DependenciesFilter dependenciesFilter;

    public AbstractArtifactVisitor(String classifier, String scope, Supplier<DependencyNodeVisitor> childVisitor) {
        this.dependenciesFilter = new DependenciesFilter(classifier, scope);
        this.childVisitor = childVisitor;
    }

    protected AbstractArtifactVisitor() {
    }

    @Override
    public void visit(ProjectDependencyNode node) throws ValidationException {
        this.collectDependencies(node);
        this.visitChildren(node);
    }

    public abstract void collectDependencies(ProjectDependencyNode var1);

    protected void visitChildren(ProjectDependencyNode node) throws ValidationException {
        Set<ProjectDependencyNode> dependencies = node.getChildren(this.dependenciesFilter);
        for (ProjectDependencyNode dependency : dependencies) {
            DependencyNodeVisitor visitor = this.childVisitor.get();
            dependency.accept(visitor);
            this.collectedDependencies.addAll(visitor.getCollectedDependencies());
        }
    }

    @Override
    public Set<ArtifactCoordinates> getCollectedDependencies() {
        return this.collectedDependencies;
    }

    public void setChildVisitor(Supplier<DependencyNodeVisitor> childVisitor) {
        this.childVisitor = childVisitor;
    }
}

