/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.ast;

import com.mulesoft.mule.framework.api.MuleFramework;
import com.mulesoft.mule.framework.api.builder.MuleVersionConfigurer;
import com.mulesoft.mule.framework.api.builder.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.Classifier;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.tools.maven.mojo.ast.AstGenerationException;
import org.mule.tools.maven.mojo.ast.AstValidatonResult;
import org.mule.tools.maven.mojo.ast.ConfigurationException;

public class AstHandler {
    private static final BundleDescriptor MULE_RUNTIME_BUNDLE_JAVA_8_DESCRIPTOR;
    private static final BundleDescriptor MULE_RUNTIME_BUNDLE_JAVA_17_DESCRIPTOR;
    private static final BundleDescriptor MULE_FRAMEWORK_IMPL_DEPENDENCIES_BUNDLE_DESCRIPTOR;
    private static final String MULE_FRAMEWORK_VERSION;
    private static final MuleVersion MULE_RUNTIME_JAVA_8_VERSION;
    private static final MuleVersion MULE_RUNTIME_JAVA_17_VERSION;
    private final MuleFramework muleFramework;
    private final ArtifactAst artifactAst;
    private Boolean useRuntimeVersion = false;
    private static final String MULE_RUNTIME_BUNDLE_JAVA_8_ARTIFACT_ID = "mule-framework-4.8-bundle";
    private static final String MULE_RUNTIME_BUNDLE_JAVA_17_ARTIFACT_ID = "mule-framework-latest-bundle";
    private static final String MULE_FRAMEWORK_IMPL_DEPENDENCIES_ARTIFACT_ID = "mule-framework";
    private static final String DEPENDENCIES_FOLDER_NAME = "build-dependencies";
    private static final String MULE_RUNTIME_4_9 = "4.9.0";

    public AstHandler(Path projectPath, Path buildPath, boolean asApplication, MavenClient mavenClient, String classifier, MuleVersion runtimeVersion, boolean useRuntimeVersion) {
        this.useRuntimeVersion = useRuntimeVersion;
        MuleFramework.Builder muleFrameworkBuilder = MuleFramework.builder(muleVersionConfigurer -> this.configureMuleVersion((MuleVersionConfigurer)muleVersionConfigurer, mavenClient, buildPath, runtimeVersion), (Path)this.getMuleFrameworkImplDependencies(mavenClient, buildPath)).usageMode(MuleFramework.UsageMode.ARTIFACT_AST);
        if (asApplication) {
            muleFrameworkBuilder.fromApplicationProject(projectPath, frameworkApplicationConfigurer -> {
                if (!Classifier.MULE_PLUGIN.toString().equals(classifier)) {
                    frameworkApplicationConfigurer.withPropertiesResolver(propertiesResolverConfigurer -> propertiesResolverConfigurer.withArtifactProperties(Collections.emptyMap()));
                }
            });
        } else {
            muleFrameworkBuilder.fromDomainProject(projectPath);
        }
        if (mavenClient != null) {
            muleFrameworkBuilder.withMavenConfiguration(mavenClient.getMavenConfiguration());
        }
        this.muleFramework = muleFrameworkBuilder.build();
        this.artifactAst = this.muleFramework.getArtifactAst().orElse(null);
        if (this.artifactAst != null) {
            this.artifactAst.updatePropertiesResolver(propertyKey -> propertyKey);
        }
    }

    private void configureMuleVersion(MuleVersionConfigurer muleVersionConfigurer, MavenClient mavenClient, Path buildPath, MuleVersion runtimeVersion) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17) && runtimeVersion.atLeastBase(MULE_RUNTIME_4_9) || this.useRuntimeVersion.booleanValue()) {
            if (runtimeVersion.newerThan(MULE_RUNTIME_JAVA_17_VERSION) || this.useRuntimeVersion.booleanValue()) {
                this.configureMuleVersion(muleVersionConfigurer, runtimeVersion, MULE_RUNTIME_BUNDLE_JAVA_17_DESCRIPTOR, mavenClient, buildPath, null);
            } else {
                this.configureMuleVersion(muleVersionConfigurer, MULE_RUNTIME_JAVA_17_VERSION, MULE_RUNTIME_BUNDLE_JAVA_17_DESCRIPTOR, mavenClient, buildPath, "mule-framework-latest-bundle-" + MULE_FRAMEWORK_VERSION);
            }
        } else {
            this.configureMuleVersion(muleVersionConfigurer, MULE_RUNTIME_JAVA_8_VERSION, MULE_RUNTIME_BUNDLE_JAVA_8_DESCRIPTOR, mavenClient, buildPath, "mule-framework-4.8-bundle-" + MULE_FRAMEWORK_VERSION);
        }
    }

    private void configureMuleVersion(MuleVersionConfigurer muleVersionConfigurer, MuleVersion muleVersion, BundleDescriptor muleRuntimeBundleDescriptor, MavenClient mavenClient, Path buildPath, String distroFolderName) {
        muleVersionConfigurer.withMuleVersion(muleVersion);
        if (distroFolderName != null) {
            Path distroLocation = this.getUnzippedFolder(muleRuntimeBundleDescriptor, mavenClient, buildPath, distroFolderName);
            muleVersionConfigurer.fromMuleDistribution(distroLocation);
        }
    }

    private Path getMuleFrameworkImplDependencies(MavenClient mavenClient, Path buildPath) {
        return this.getUnzippedFolder(MULE_FRAMEWORK_IMPL_DEPENDENCIES_BUNDLE_DESCRIPTOR, mavenClient, buildPath, "mule-framework-" + MULE_FRAMEWORK_VERSION);
    }

    private Path getUnzippedFolder(BundleDescriptor bundleDescriptor, MavenClient mavenClient, Path buildPath, String dependencyFolderNamePrefix) {
        Path path;
        block9: {
            Path dependenciesLocation = buildPath.resolve(DEPENDENCIES_FOLDER_NAME);
            Optional<Path> dependencyLocation = this.getAlreadyUnzippedDependency(dependenciesLocation, dependencyFolderNamePrefix);
            if (dependencyLocation.isPresent()) {
                return dependencyLocation.get();
            }
            BundleDependency bundleDependency = mavenClient.resolveBundleDescriptor(bundleDescriptor);
            Path dependencyZipPath = Paths.get(bundleDependency.getBundleUri());
            InputStream dependencyZipContent = Files.newInputStream(dependencyZipPath.toFile().toPath(), new OpenOption[0]);
            try {
                FileUtils.unzip((InputStream)dependencyZipContent, (File)dependenciesLocation.toFile());
                Optional<Path> unzippedDependencyLocation = this.getAlreadyUnzippedDependency(dependenciesLocation, dependencyFolderNamePrefix);
                path = unzippedDependencyLocation.orElseThrow(() -> new IllegalStateException("Unable to unzip dependency '" + dependencyFolderNamePrefix + "'\n" + this.getTopLevelFoldersTree(dependenciesLocation)));
                if (dependencyZipContent == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dependencyZipContent != null) {
                        try {
                            dependencyZipContent.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            dependencyZipContent.close();
        }
        return path;
    }

    public Optional<Path> getAlreadyUnzippedDependency(Path dependenciesLocation, String dependencyFolderNamePrefix) {
        Optional<Path> optional;
        block10: {
            if (!Files.exists(dependenciesLocation, new LinkOption[0])) {
                return Optional.empty();
            }
            if (!Files.isDirectory(dependenciesLocation, new LinkOption[0])) {
                throw new IllegalArgumentException("The dependencies location '" + dependenciesLocation + "' is not a directory");
            }
            Stream<Path> entries = Files.list(dependenciesLocation);
            try {
                optional = entries.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(dependencyFolderNamePrefix)).findFirst();
                if (entries == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error scanning dependencies location '" + dependenciesLocation + "'", e);
                }
            }
            entries.close();
        }
        return optional;
    }

    private String getTopLevelFoldersTree(Path directoryPath) {
        List subdirectories;
        if (!Files.exists(directoryPath, new LinkOption[0]) || !Files.isDirectory(directoryPath, new LinkOption[0])) {
            return "Directory does not exist or is not a directory: " + directoryPath;
        }
        try (Stream<Path> entries = Files.list(directoryPath);){
            subdirectories = entries.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            return "Couldn't list subdirectories of '" + directoryPath + "': " + e;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(directoryPath.getFileName()).append("/\n");
        if (subdirectories.isEmpty()) {
            sb.append("\u2514\u2500\u2500 (no subdirectories)\n");
            return sb.toString();
        }
        for (int i = 0; i < subdirectories.size(); ++i) {
            boolean isLast = i == subdirectories.size() - 1;
            String prefix = isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
            sb.append(prefix).append(((Path)subdirectories.get(i)).getFileName()).append("/\n");
        }
        return sb.toString();
    }

    public ArtifactAst getAst() {
        return this.artifactAst;
    }

    public AstValidatonResult validateAST() throws ConfigurationException, AstGenerationException {
        ValidationResult result;
        try {
            result = (ValidationResult)this.muleFramework.onExecutionClassLoader(() -> MuleAstUtils.validatorBuilder().ignoreParamsWithProperties(true).build().validate(this.artifactAst));
        }
        catch (Exception e) {
            throw new AstGenerationException("AST validation failed", e);
        }
        ArrayList<ValidationResultItem> dynamicStructureErrors = new ArrayList<ValidationResultItem>();
        ArrayList<ValidationResultItem> errors = new ArrayList<ValidationResultItem>();
        ArrayList<ValidationResultItem> warnings = new ArrayList<ValidationResultItem>();
        result.getItems().forEach(v -> {
            if (v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)) {
                if (v.causedByDynamicArtifact()) {
                    dynamicStructureErrors.add((ValidationResultItem)v);
                } else {
                    errors.add((ValidationResultItem)v);
                }
            } else {
                warnings.add((ValidationResultItem)v);
            }
        });
        if (errors.size() > 0) {
            throw new ConfigurationException(errors.stream().map(AstHandler::validationResultItemToString).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), System.lineSeparator())));
        }
        return new AstValidatonResult(errors, warnings, dynamicStructureErrors);
    }

    public static String validationResultItemToString(ValidationResultItem v) {
        return v.getComponents().stream().map(component -> component.getMetadata().getFileName().orElse("unknown") + ":" + component.getMetadata().getStartLine().orElse(-1)).collect(Collectors.joining("; ", "[", "]")) + ": " + v.getMessage();
    }

    public InputStream serialize() {
        try {
            return (InputStream)this.muleFramework.onExecutionClassLoader(() -> new ArtifactAstSerializerProvider().getSerializer("JSON", "1.0").serialize(this.artifactAst));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Properties artifactInfo = new Properties();
            artifactInfo.load(AstHandler.class.getResourceAsStream("/artifact-info.properties"));
            MULE_RUNTIME_JAVA_8_VERSION = new MuleVersion(artifactInfo.getProperty("muleRuntimeJava8Version"));
            MULE_RUNTIME_JAVA_17_VERSION = new MuleVersion(artifactInfo.getProperty("muleRuntimeJava17Version"));
            MULE_FRAMEWORK_VERSION = artifactInfo.getProperty("muleFrameworkVersion");
            MULE_RUNTIME_BUNDLE_JAVA_8_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("com.mulesoft.mule.framework").setArtifactId(MULE_RUNTIME_BUNDLE_JAVA_8_ARTIFACT_ID).setVersion(MULE_FRAMEWORK_VERSION).setBaseVersion(MULE_FRAMEWORK_VERSION).setType("zip").build();
            MULE_RUNTIME_BUNDLE_JAVA_17_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("com.mulesoft.mule.framework").setArtifactId(MULE_RUNTIME_BUNDLE_JAVA_17_ARTIFACT_ID).setVersion(MULE_FRAMEWORK_VERSION).setBaseVersion(MULE_FRAMEWORK_VERSION).setType("zip").build();
            MULE_FRAMEWORK_IMPL_DEPENDENCIES_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("com.mulesoft.mule.framework").setArtifactId(MULE_FRAMEWORK_IMPL_DEPENDENCIES_ARTIFACT_ID).setVersion(MULE_FRAMEWORK_VERSION).setBaseVersion(MULE_FRAMEWORK_VERSION).setClassifier("dependencies").setType("zip").build();
        }
        catch (IOException e) {
            throw new RuntimeException("There was a problem loading the Connectors versions used in the tests", e);
        }
    }
}

