/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.tools.api.exception.ValidationException;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.sources.MuleArtifactContentResolver;
import org.mule.tools.api.packager.sources.MuleContentGenerator;
import org.mule.tools.api.packager.structure.ProjectStructure;
import org.mule.tools.api.util.FileJarExplorer;
import org.mule.tools.maven.mojo.AbstractMuleMojo;
import org.mule.tools.maven.mojo.ast.AstGenerationException;
import org.mule.tools.maven.mojo.ast.AstHandler;
import org.mule.tools.maven.mojo.ast.AstValidatonResult;
import org.mule.tools.maven.mojo.ast.ConfigurationException;
import org.mule.tools.maven.mojo.ast.DynamicStructureException;
import org.mule.tools.maven.mojo.model.lifecycle.MavenLifecyclePhase;

@Mojo(name="process-classes", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class ProcessClassesMojo
extends AbstractMuleMojo {
    private static final String MULE_POLICY = "mule-policy";
    private static final String MULE_DOMAIN = "mule-domain";
    private static final String SKIP_AST = "skipAST";
    private static final String SKIP_AST_VALIDATION = "skipASTValidation";

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        block10: {
            this.getLog().debug((CharSequence)"Generating process-classes code...");
            try {
                String skipAST = System.getProperty(SKIP_AST);
                if (!(skipAST != null && !skipAST.equals("false") || this.project.getPackaging().equals(MULE_POLICY) || this.hasDomain())) {
                    if (this.hasConfigs()) {
                        this.processAst();
                    } else {
                        ((MuleContentGenerator)this.getContentGenerator()).createDwlFile(Collections.emptySet());
                    }
                }
            }
            catch (IOException | IllegalArgumentException | ConfigurationException e) {
                throw new MojoFailureException("Fail to compile", (Throwable)e);
            }
            catch (NullPointerException e) {
                String className = "org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation";
                String methodName = "isErrorTypePresent";
                if (e.getStackTrace().length > 1 && Objects.equals("org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation", e.getStackTrace()[0].getClassName()) && Objects.equals("isErrorTypePresent", e.getStackTrace()[0].getMethodName())) break block10;
                throw new MojoFailureException("Fail to compile", (Throwable)e);
            }
        }
        try {
            this.getContentGenerator().copyDescriptorFile();
            if (!this.skipValidation) {
                this.getLog().debug((CharSequence)"executing validations in process-classes for Mule application");
                this.getProjectValidator().isProjectValid(MavenLifecyclePhase.VALIDATE.id());
            } else {
                this.getLog().debug((CharSequence)"Skipping process-classes validation for Mule application");
            }
        }
        catch (IOException | ValidationException e) {
            throw new MojoExecutionException("process-classes exception", (Exception)e);
        }
    }

    private boolean hasConfigs() throws IOException {
        Path configsPath = new ProjectStructure(this.projectBaseFolder.toPath(), false).getConfigsPath();
        if (!Files.exists(configsPath, new LinkOption[0]) || !Files.isDirectory(configsPath, new LinkOption[0])) {
            throw new RuntimeException("Configs directory does not exist or is not a directory: " + configsPath);
        }
        try (Stream<Path> files = Files.list(configsPath);){
            boolean bl = files.anyMatch(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().toLowerCase().endsWith(".xml"));
            return bl;
        }
    }

    private void processAst() throws IOException, ConfigurationException, MojoExecutionException {
        AstHandler astHandler;
        try {
            astHandler = this.getArtifactAstHandler();
        }
        catch (DynamicStructureException e) {
            this.getLog().warn((CharSequence)"The application has a dynamic structure based on properties available only at design time, so an artifact AST for it cannot be generated at this time. See previous WARN messages for where that dynamic structure is being detected.");
            return;
        }
        catch (AstGenerationException e) {
            throw new RuntimeException(e);
        }
        if (astHandler.getAst() != null) {
            ((MuleContentGenerator)this.getContentGenerator()).createAstFile(astHandler.serialize());
        }
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_PROCESS_CLASSES_PREVIOUS_RUN_PLACEHOLDER";
    }

    public AstHandler getArtifactAstHandler() throws IOException, ConfigurationException, DynamicStructureException, MojoExecutionException, AstGenerationException {
        ProjectStructure projectStructure = new ProjectStructure(this.projectBaseFolder.toPath(), false);
        MuleArtifactContentResolver contentResolver = new MuleArtifactContentResolver(projectStructure, this.getProjectInformation().getEffectivePom(), this.getProjectInformation().getProject().getBundleDependencies());
        ((MuleContentGenerator)this.getContentGenerator()).createDwlFile(this.getDwlFiles(this.project.getArtifacts()));
        AstHandler astHandler = new AstHandler(this.projectBaseFolder.toPath(), projectStructure.getprojectBuildDirectory().toAbsolutePath(), contentResolver.isApplication(), this.getMavenClient(), this.getClassifier(), new MuleVersion(this.getMuleApplicationModelLoader().getRuntimeVersion()), StringUtils.isNotBlank((CharSequence)this.runtimeVersion));
        ArtifactAst artifactAST = astHandler.getAst();
        if (artifactAST != null && !this.getClassifier().equalsIgnoreCase(Classifier.MULE_PLUGIN.toString()) && !"true".equals(System.getProperty(SKIP_AST_VALIDATION))) {
            AstValidatonResult validationResult = astHandler.validateAST();
            for (ValidationResultItem warning : validationResult.getWarnings()) {
                this.getLog().warn((CharSequence)AstHandler.validationResultItemToString(warning));
            }
            if (!validationResult.getDynamicStructureErrors().isEmpty()) {
                for (ValidationResultItem dynamicStructureError : validationResult.getDynamicStructureErrors()) {
                    this.getLog().warn((CharSequence)AstHandler.validationResultItemToString(dynamicStructureError));
                }
                throw new DynamicStructureException();
            }
        }
        return astHandler;
    }

    private Set<String> getDwlFiles(Set<Artifact> dependencies) {
        return dependencies.stream().flatMap(dependency -> new FileJarExplorer().explore(dependency.getFile().toURI()).getResources().stream().filter(resource -> resource.endsWith(".dwl"))).collect(Collectors.toSet());
    }

    private boolean hasDomain() {
        if (this.project.getDependencies() != null) {
            for (Dependency dependency : this.project.getDependencies()) {
                if (dependency.getClassifier() == null || !dependency.getClassifier().equals(MULE_DOMAIN)) continue;
                return true;
            }
        }
        return false;
    }
}

