/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.resources.content.ResourcesContent;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.sources.ContentGeneratorFactory;
import org.mule.tools.api.util.MavenProjectBuilder;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.resolver.MulePluginResolver;
import org.mule.tools.maven.mojo.AbstractGenericMojo;
import org.mule.tools.maven.utils.MuleApplicationModelLoader;

public abstract class AbstractMuleMojo
extends AbstractGenericMojo {
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(property="project.build.directory", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${skipValidation}")
    protected boolean skipValidation = false;
    @Parameter(property="runtimeVersion")
    public String runtimeVersion;
    protected ContentGenerator contentGenerator;
    protected static ResourcesContent resourcesContent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.hasExecutedBefore()) {
            this.initMojo();
            this.doExecute();
        } else {
            this.getLog().debug((CharSequence)"Skipping execution because it has already been run");
        }
    }

    public ContentGenerator getContentGenerator() {
        if (this.contentGenerator == null) {
            this.contentGenerator = ContentGeneratorFactory.create((ProjectInformation)this.getProjectInformation(), (Parent)this.project.getModel().getParent());
        }
        return this.contentGenerator;
    }

    protected MulePluginResolver getResolver(Project project) {
        MavenProjectBuilder builder = new MavenProjectBuilder(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
        return new MulePluginResolver((org.mule.tools.api.util.ProjectBuilder)builder, project);
    }

    protected MuleApplicationModelLoader getMuleApplicationModelLoader() throws MojoExecutionException {
        return new MuleApplicationModelLoader(this.getMuleApplicationModel(), this.getLog()).withRuntimeVersion(this.runtimeVersion);
    }

    protected MuleApplicationModel getMuleApplicationModel() throws MojoExecutionException {
        File muleApplicationJsonPath = this.getMuleApplicationJsonPath();
        try {
            return (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(FileUtils.readFileToString((File)muleApplicationJsonPath, (Charset)Charset.defaultCharset()));
        }
        catch (IOException e) {
            String message = "Fail to read mule application file from " + muleApplicationJsonPath;
            this.getLog().error((CharSequence)message, (Throwable)e);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    protected File getMuleApplicationJsonPath() {
        return Paths.get(this.project.getBasedir().getPath(), new String[0]).resolve("mule-artifact.json").toFile();
    }
}

