/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.DefaultDeployer;
import org.mule.tools.maven.mojo.deploy.AbstractMuleDeployerMojo;
import org.mule.tools.model.Deployment;
import org.mule.tools.validation.DeploymentValidatorFactory;

@Mojo(name="deploy", requiresProject=true)
public class DeployMojo
extends AbstractMuleDeployerMojo {
    @Component
    protected ArchiverManager archiverManager;

    @Override
    public void doExecute() throws MojoFailureException, MojoExecutionException {
        try {
            if (this.deploymentConfiguration.validateVersion()) {
                DeploymentValidatorFactory.createDeploymentValidator((Deployment)this.deploymentConfiguration).validateMuleVersionAgainstEnvironment();
            }
            DefaultDeployer deployer = new DefaultDeployer(this.deploymentConfiguration, this.log);
            deployer.deploy();
        }
        catch (DeploymentException e) {
            this.getLog().error((CharSequence)("Failed to deploy " + this.deploymentConfiguration.getApplicationName() + ": " + e.getMessage()), (Throwable)e);
            throw new MojoFailureException("Failed to deploy [" + this.deploymentConfiguration.getArtifact() + "]");
        }
    }

    @Override
    public String getPreviousRunPlaceholder() {
        return "MULE_MAVEN_PLUGIN_DEPLOY_PREVIOUS_RUN_PLACEHOLDER";
    }
}

