/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo.deploy;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.maven.mojo.deploy.configuration.DeploymentDefaultValuesSetter;
import org.mule.tools.maven.mojo.deploy.logging.MavenDeployerLog;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.agent.AgentDeployment;
import org.mule.tools.model.anypoint.AnypointDeployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.model.anypoint.DeploymentConfigurator;
import org.mule.tools.model.standalone.ClusterDeployment;
import org.mule.tools.model.standalone.StandaloneDeployment;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractMuleDeployerMojo
extends AbstractMojo {
    protected Deployment deploymentConfiguration;
    @Parameter
    protected CloudHubDeployment cloudHubDeployment;
    @Parameter
    protected ArmDeployment armDeployment;
    @Parameter
    protected StandaloneDeployment standaloneDeployment;
    @Parameter
    protected AgentDeployment agentDeployment;
    @Parameter
    protected ClusterDeployment clusterDeployment;
    @Component
    protected Settings settings;
    @Component
    protected SettingsDecrypter decrypter;
    @Component
    protected MavenProject mavenProject;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    private DeploymentConfigurator deploymentConfigurator;
    @Parameter(readonly=true, property="applicationName", defaultValue="${project.artifactId}")
    protected String applicationName;
    @Parameter(readonly=true, property="artifact", defaultValue="${project.artifact.file}")
    protected String artifact;
    protected DeployerLog log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateUniqueDeployment();
        this.validateIsDeployable();
        this.log = new MavenDeployerLog(this.getLog());
        if (this.deploymentConfiguration == null) {
            throw new MojoFailureException("No deployment configuration was defined. Aborting.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.deploymentConfiguration.getSkip()) && "true".equals(this.deploymentConfiguration.getSkip())) {
            this.getLog().info((CharSequence)("Skipping execution: skip=" + this.deploymentConfiguration.getSkip()));
        } else if (this.deploymentConfiguration instanceof AnypointDeployment) {
            this.deploymentConfigurator = new DeploymentConfigurator((AnypointDeployment)this.deploymentConfiguration, (DeployerLog)new MavenDeployerLog(this.getLog()));
            this.deploymentConfigurator.initializeApplication(this.artifactFactory, this.mavenProject, this.artifactResolver, this.localRepository);
            this.deploymentConfigurator.initializeEnvironment(this.settings, this.decrypter);
            this.getLog().debug((CharSequence)("Executing mojo, skip=" + this.deploymentConfiguration.getSkip()));
        }
    }

    protected void validateIsDeployable() throws MojoExecutionException {
        if (!this.mavenProject.getAttachedArtifacts().isEmpty()) {
            String classifier = ((Artifact)this.mavenProject.getAttachedArtifacts().get(0)).getClassifier();
            Set<String> forbiddenClassifiers = this.getForbiddenClassifiers();
            if (classifier != null && forbiddenClassifiers.contains(classifier)) {
                throw new MojoExecutionException("Cannot deploy a " + classifier + " project");
            }
        }
    }

    private void validateUniqueDeployment() throws MojoExecutionException {
        this.checkDeployment((Deployment)this.cloudHubDeployment, this.deploymentConfiguration);
        this.checkDeployment((Deployment)this.armDeployment, this.deploymentConfiguration);
        this.checkDeployment((Deployment)this.standaloneDeployment, this.deploymentConfiguration);
        this.checkDeployment((Deployment)this.agentDeployment, this.deploymentConfiguration);
        this.checkDeployment((Deployment)this.clusterDeployment, this.deploymentConfiguration);
        Preconditions.checkState((this.deploymentConfiguration != null ? 1 : 0) != 0, (Object)"Deployment configuration is missing");
    }

    protected void checkDeployment(Deployment deploymentImplementation, Deployment deploymentConfiguration) throws MojoExecutionException {
        if (deploymentImplementation != null) {
            if (deploymentConfiguration != null) {
                throw new MojoExecutionException("One and only one deployment type can be set up per build. Aborting");
            }
            new DeploymentDefaultValuesSetter().setDefaultValues(deploymentImplementation, this.mavenProject);
            this.deploymentConfiguration = deploymentImplementation;
        }
    }

    public Set<String> getForbiddenClassifiers() {
        HashSet<String> forbiddenClassifiers = new HashSet<String>();
        forbiddenClassifiers.add(Classifier.MULE_DOMAIN.toString());
        forbiddenClassifiers.add(Classifier.MULE_APPLICATION_TEMPLATE.toString());
        return forbiddenClassifiers;
    }
}

