/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.mule.tools.api.packager.builder.PackageBuilder;
import org.mule.tools.api.packager.builder.PackageBuilderFactory;
import org.mule.tools.api.packager.packaging.Classifier;
import org.mule.tools.api.packager.packaging.PackagingOptions;
import org.mule.tools.api.packager.packaging.PackagingType;
import org.mule.tools.maven.mojo.AbstractMuleMojo;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class PackageMojo
extends AbstractMuleMojo {
    private static final String JAR_EXTENSION = "jar";
    private static final String ZIP_EXTENSION = "zip";
    @Component
    protected MavenProjectHelper helper;
    @Parameter(defaultValue="${onlyMuleSources}")
    protected boolean onlyMuleSources = false;
    @Parameter(defaultValue="${attachMuleSources}")
    protected boolean attachMuleSources = false;
    protected PackagingOptions options;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.currentTimeMillis();
        this.getLog().debug((CharSequence)"Packaging...");
        String targetFolder = this.project.getBuild().getDirectory();
        File destinationFile = this.getDestinationFile(targetFolder);
        try {
            this.getPackageBuilder().createPackage(Paths.get(targetFolder, new String[0]), destinationFile.toPath());
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)e);
        }
        this.helper.attachArtifact(this.project, this.getType(), this.getPackagingType().resolveClassifier(this.classifier, this.lightweightPackage, this.testJar), destinationFile);
        this.getLog().debug((CharSequence)MessageFormat.format("Package done ({0}ms)", System.currentTimeMillis() - start));
    }

    protected File getDestinationFile(String targetFolder) throws MojoExecutionException {
        Preconditions.checkArgument((targetFolder != null ? 1 : 0) != 0, (Object)"The target folder must not be null");
        Path destinationPath = Paths.get(targetFolder, this.getFileName());
        try {
            Files.deleteIfExists(destinationPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Exception deleting the file [%s]", destinationPath), (Exception)e);
        }
        return destinationPath.toFile();
    }

    protected String getFileName() {
        return this.project.getBuild().getFinalName() + "-" + this.getPackagingType().resolveClassifier(this.classifier, this.lightweightPackage, this.testJar) + "." + this.getType();
    }

    protected PackageBuilder getPackageBuilder() {
        boolean isMuleApplicationTemplate = Classifier.MULE_APPLICATION_TEMPLATE.equals(this.classifier);
        this.options = new PackagingOptions(isMuleApplicationTemplate || this.onlyMuleSources, this.lightweightPackage, this.attachMuleSources, this.testJar);
        return PackageBuilderFactory.create((PackagingType)this.getPackagingType(), (PackagingOptions)this.options);
    }

    private String getType() {
        return this.getPackagingType().equals((Object)PackagingType.MULE_DOMAIN_BUNDLE) ? ZIP_EXTENSION : JAR_EXTENSION;
    }

    private PackagingType getPackagingType() {
        return PackagingType.fromString((String)this.project.getPackaging());
    }
}

