/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.mojo;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.mule.maven.client.internal.AetherMavenClient;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.SharedLibraryDependency;
import org.mule.tools.api.packager.ProjectInformation;
import org.mule.tools.api.packager.resources.content.ResourcesContent;
import org.mule.tools.api.packager.sources.ContentGenerator;
import org.mule.tools.api.packager.sources.ContentGeneratorFactory;
import org.mule.tools.api.repository.MuleMavenPluginClientBuilder;
import org.mule.tools.api.util.PackagerLog;
import org.mule.tools.api.util.Project;
import org.mule.tools.api.validation.MulePluginResolver;
import org.mule.tools.maven.utils.ArtifactUtils;
import org.mule.tools.maven.utils.DependencyProject;
import org.mule.tools.maven.utils.MavenPackagerLog;
import org.mule.tools.maven.utils.MavenProjectBuilder;

public abstract class AbstractMuleMojo
extends AbstractMojo {
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(readonly=true, required=true, defaultValue="${session}")
    protected MavenSession session;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(property="project", required=true)
    protected MavenProject project;
    @Parameter(property="project.build.directory", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project.basedir}")
    protected File projectBaseFolder;
    @Parameter(defaultValue="${lightweightPackage}")
    protected boolean lightweightPackage = false;
    @Parameter(defaultValue="${skipValidation}")
    protected boolean skipValidation = false;
    @Parameter(property="shared.libraries")
    protected List<SharedLibraryDependency> sharedLibraries;
    @Parameter(defaultValue="${testJar}")
    protected boolean testJar = false;
    @Parameter
    protected String classifier;
    protected ContentGenerator contentGenerator;
    protected static ResourcesContent resourcesContent;
    protected AetherMavenClient aetherMavenClient;
    protected ProjectInformation projectInformation;

    protected AetherMavenClient getAetherMavenClient() {
        if (this.aetherMavenClient == null) {
            MavenExecutionRequest request = this.session.getRequest();
            List remoteRepositories = RepositoryUtils.toRepos(this.remoteArtifactRepositories);
            this.aetherMavenClient = new MuleMavenPluginClientBuilder((PackagerLog)new MavenPackagerLog(this.getLog())).withRemoteRepositories(remoteRepositories).withLocalRepository(request.getLocalRepositoryPath()).withUserSettings(request.getUserSettingsFile()).withGlobalSettings(request.getGlobalSettingsFile()).build();
        }
        return this.aetherMavenClient;
    }

    protected List<ArtifactCoordinates> toArtifactCoordinates(List<Dependency> dependencies) {
        return dependencies.stream().map(ArtifactUtils::toArtifactCoordinates).collect(Collectors.toList());
    }

    protected ProjectInformation getProjectInformation() {
        if (this.projectInformation == null) {
            this.projectInformation = new ProjectInformation.Builder().withGroupId(this.project.getGroupId()).withArtifactId(this.project.getArtifactId()).withVersion(this.project.getVersion()).withPackaging(this.project.getPackaging()).withProjectBaseFolder(Paths.get(this.projectBaseFolder.toURI())).withBuildDirectory(Paths.get(this.project.getBuild().getDirectory(), new String[0])).setTestProject(Boolean.valueOf(this.testJar)).withDependencyProject((Project)new DependencyProject(this.project)).build();
        }
        return this.projectInformation;
    }

    public ContentGenerator getContentGenerator() {
        if (this.contentGenerator == null) {
            this.contentGenerator = ContentGeneratorFactory.create((ProjectInformation)this.getProjectInformation());
        }
        return this.contentGenerator;
    }

    protected MulePluginResolver getResolver() {
        MavenProjectBuilder builder = new MavenProjectBuilder(this.getLog(), this.session, this.projectBuilder, this.repositorySystem, this.localRepository, this.remoteArtifactRepositories);
        return new MulePluginResolver((org.mule.tools.api.util.ProjectBuilder)builder);
    }
}

