/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin.mule;

import java.util.ArrayList;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;
import org.mule.tools.maven.plugin.mule.AbstractApi;
import org.mule.tools.maven.plugin.mule.ApiException;
import org.mule.tools.maven.plugin.mule.arm.AuthorizationResponse;
import org.mule.tools.maven.plugin.mule.arm.Environment;
import org.mule.tools.maven.plugin.mule.arm.Environments;
import org.mule.tools.maven.plugin.mule.arm.UserInfo;

public abstract class AbstractMuleApi
extends AbstractApi {
    private static final String ME = "/accounts/api/me";
    private static final String LOGIN = "/accounts/login";
    private static final String ENVIRONMENTS = "/accounts/api/organizations/%s/environments";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String ENV_ID_HEADER = "X-ANYPNT-ENV-ID";
    private static final String ORG_ID_HEADER = "X-ANYPNT-ORG-ID";
    protected String uri;
    private String username;
    private String password;
    private String environment;
    private final String businessGroup;
    private String bearerToken;
    private String envId;
    private String orgId;

    public AbstractMuleApi(String uri, Log log, String username, String password, String environment, String businessGroup) {
        super(log);
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.environment = environment;
        this.businessGroup = businessGroup;
    }

    public void init() {
        this.bearerToken = this.getBearerToken(this.username, this.password);
        this.orgId = this.getOrgId();
        this.envId = this.findEnvironmentByName((String)this.environment).id;
    }

    private String getBearerToken(String username, String password) {
        Entity json = Entity.json((Object)("{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}"));
        Response response = this.post(this.uri, LOGIN, json);
        this.validateStatusSuccess(response);
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)response.readEntity(AuthorizationResponse.class);
        return authorizationResponse.access_token;
    }

    protected void validateStatusSuccess(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ApiException(response);
        }
    }

    public String getOrgId() {
        return this.findBusinessGroup();
    }

    public Environment findEnvironmentByName(String name) {
        Environments response = this.get(this.uri, String.format(ENVIRONMENTS, this.orgId), Environments.class);
        for (int i = 0; i < response.data.length; ++i) {
            if (!name.equals(response.data[i].name)) continue;
            return response.data[i];
        }
        throw new RuntimeException("Couldn't find environment named [" + name + "]");
    }

    @Override
    protected void configureRequest(Invocation.Builder builder) {
        if (this.bearerToken != null) {
            builder.header(AUTHORIZATION_HEADER, (Object)("bearer " + this.bearerToken));
        }
        if (this.envId != null && this.orgId != null) {
            builder.header(ENV_ID_HEADER, (Object)this.envId);
            builder.header(ORG_ID_HEADER, (Object)this.orgId);
        }
    }

    private JSONObject getHierarchy() {
        UserInfo response = this.get(this.uri, ME, UserInfo.class);
        String rootOrgId = response.user.organization.id;
        return new JSONObject(this.get(this.uri, "accounts/api/organizations/" + rootOrgId + "/hierarchy", String.class));
    }

    public String findBusinessGroup() {
        String currentOrgId = null;
        String[] groups = this.createBusinessGroupPath();
        JSONObject json = this.getHierarchy();
        JSONArray subOrganizations = (JSONArray)json.get("subOrganizations");
        if (groups.length == 0) {
            return (String)json.get("id");
        }
        for (int group = 0; group < groups.length; ++group) {
            for (int organization = 0; organization < subOrganizations.length(); ++organization) {
                JSONObject jsonObject = (JSONObject)subOrganizations.get(organization);
                if (!jsonObject.get("name").equals(groups[group])) continue;
                currentOrgId = (String)jsonObject.get("id");
                subOrganizations = (JSONArray)jsonObject.get("subOrganizations");
            }
        }
        if (currentOrgId == null) {
            throw new ArrayIndexOutOfBoundsException("Cannot find business group.");
        }
        return currentOrgId;
    }

    protected String[] createBusinessGroupPath() {
        int i;
        if (StringUtils.isEmpty((String)this.businessGroup)) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        String group = "";
        for (i = 0; i < this.businessGroup.length() - 1; ++i) {
            if (this.businessGroup.charAt(i) == '\\') {
                if (this.businessGroup.charAt(i + 1) == '\\') {
                    group = group + "\\";
                    ++i;
                    continue;
                }
                groups.add(group);
                group = "";
                continue;
            }
            group = group + this.businessGroup.charAt(i);
        }
        if (i < this.businessGroup.length()) {
            group = group + this.businessGroup.charAt(this.businessGroup.length() - 1);
        }
        groups.add(group);
        return groups.toArray(new String[0]);
    }
}

