/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.internal.util.FileUtils;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenModelBuilder;
import org.mule.maven.pom.parser.api.model.MavenModelBuilderProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.extension.api.provider.RuntimeExtensionModelProviderLoaderUtils;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionDiscoveryRequest;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.tooling.api.ExtensionModelService;
import org.mule.tooling.api.ToolingException;
import org.mule.tooling.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.internal.PluginResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelService
implements ExtensionModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelService.class);
    private static final String MULE_APPLICATION = "mule-application";
    private static final String MAVEN_MODEL_VERSION = "4.0.0";
    private final MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private final List<ExtensionModel> runtimeExtensionModels = new ArrayList<ExtensionModel>();

    public static Model getPomModelFromJar(File artifactFile) {
        String pomFilePath = "META-INF/mule-artifact/pom.xml";
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            return reader.read((InputStream)new ByteArrayInputStream((byte[])FileUtils.loadFileContentFrom((URL)org.mule.maven.pom.parser.internal.util.FileUtils.getPomUrlFromJar((File)artifactFile)).get()));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an issue reading '%s' for the artifact '%s'", pomFilePath, artifactFile.getAbsolutePath()), e);
        }
    }

    public DefaultExtensionModelService(MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
        this.runtimeExtensionModels.addAll(RuntimeExtensionModelProviderLoaderUtils.discoverRuntimeExtensionModels());
    }

    @Override
    public List<ExtensionModel> loadRuntimeExtensionModels() {
        return this.runtimeExtensionModels;
    }

    @Override
    public PluginResources loadExtensionData(File pluginJarFile) {
        long startTime = System.nanoTime();
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = this.readArtifactPluginDescriptor(pluginJarFile).getBundleDescriptor();
        HashMap<String, Object> classLoaderModelAttributes = new HashMap<String, Object>();
        classLoaderModelAttributes.put("_classLoaderModelMavenReactorResolver", new PluginFileMavenReactor(bundleDescriptor, pluginJarFile, this.muleArtifactResourcesRegistry.getWorkingDirectory()));
        BundleDescriptor pluginDescriptor = new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setVersion(bundleDescriptor.getVersion()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null)).build();
        PluginResources extensionInformationOptional = this.withTemporaryApplication(pluginDescriptor, classLoaderModelAttributes, this::loadExtensionData, null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extension model for {} loaded in {}ms", (Object)pluginJarFile, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        }
        return extensionInformationOptional;
    }

    @Override
    public BundleDescriptor readBundleDescriptor(File pluginFile) {
        org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor bundleDescriptor = this.readArtifactPluginDescriptor(pluginFile).getBundleDescriptor();
        return new BundleDescriptor.Builder().setGroupId(bundleDescriptor.getGroupId()).setArtifactId(bundleDescriptor.getArtifactId()).setBaseVersion(bundleDescriptor.getVersion()).setVersion(bundleDescriptor.getVersion()).setType(bundleDescriptor.getType()).setClassifier((String)bundleDescriptor.getClassifier().orElse(null)).build();
    }

    private ArtifactPluginDescriptor readArtifactPluginDescriptor(File pluginFile) {
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.muleArtifactResourcesRegistry.getArtifactPluginDescriptorLoader().load(pluginFile);
            return artifactPluginDescriptor;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + pluginFile.getAbsolutePath(), e);
        }
    }

    @Override
    public PluginResources loadExtensionData(BundleDescriptor pluginDescriptor, MuleVersion muleVersion) {
        long startTime = System.nanoTime();
        PluginResources extensionInformation = this.withTemporaryApplication(pluginDescriptor, Collections.emptyMap(), this::loadExtensionData, muleVersion);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extension model for {} loaded in {}ms", (Object)pluginDescriptor, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
        }
        return extensionInformation;
    }

    /*
     * Exception decompiling
     */
    private PluginResources withTemporaryApplication(BundleDescriptor pluginDescriptor, Map<String, Object> classLoaderModelLoaderAttributes, TemporaryApplicationFunction action, MuleVersion muleVersion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File createTempDir() throws IOException {
        File tempFolder = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        File moduleDiscovererTemporaryFolder = new File(tempFolder, ".moduleDiscoverer");
        if (!moduleDiscovererTemporaryFolder.mkdir()) {
            throw new IOException("Error while generating class loaders, cannot create directory " + moduleDiscovererTemporaryFolder.getAbsolutePath());
        }
        return moduleDiscovererTemporaryFolder;
    }

    private void createPomFile(BundleDescriptor pluginDescriptor, String uuid, File applicationFolder) {
        MavenModelBuilderProvider mavenModelBuilderProvider = MavenModelBuilderProvider.discoverProvider();
        MavenModelBuilder model = mavenModelBuilderProvider.createMavenModelBuilder(uuid, uuid, MuleManifest.getProductVersion(), Optional.of(MAVEN_MODEL_VERSION), Optional.of(MULE_APPLICATION));
        model.addDependency(new BundleDependency.Builder().setBundleDescriptor(pluginDescriptor).build());
        Properties pomProperties = new Properties();
        pomProperties.setProperty("groupId", model.getModel().getGroupId());
        pomProperties.setProperty("artifactId", model.getModel().getArtifactId());
        pomProperties.setProperty("version", model.getModel().getVersion());
        model.createDeployablePomFile(applicationFolder.toPath());
        model.createDeployablePomProperties(applicationFolder.toPath(), pomProperties);
    }

    private PluginResources loadExtensionData(ArtifactPluginDescriptor artifactPluginDescriptor, MuleDeployableArtifactClassLoader artifactClassLoader, Map<String, String> properties) {
        try {
            ArrayList<URL> resources = new ArrayList<URL>();
            artifactPluginDescriptor.getClassLoaderConfiguration().getExportedResources().forEach(resource -> {
                if (artifactClassLoader.getParent().getResource((String)resource) != null) {
                    resources.add(artifactClassLoader.getParent().getResource((String)resource));
                }
            });
            ExtensionModelLoaderRepository extensionModelLoaderRepository = ExtensionModelLoaderRepository.getExtensionModelLoaderManager();
            LifecycleUtils.startIfNeeded((Object)extensionModelLoaderRepository);
            Set<ExtensionModel> loadedExtensionInformation = this.discoverPluginsExtensionModel(artifactClassLoader, extensionModelLoaderRepository, properties);
            PluginResources pluginResources = new PluginResources(loadedExtensionInformation, resources);
            return pluginResources;
        }
        catch (Exception e) {
            throw new ToolingException(e);
        }
        finally {
            if (artifactClassLoader != null) {
                artifactClassLoader.dispose();
            }
        }
    }

    private Set<ExtensionModel> discoverPluginsExtensionModel(MuleDeployableArtifactClassLoader artifactClassLoader, ExtensionModelLoaderRepository extensionModelLoaderRepository, Map<String, String> properties) {
        Set artifactPluginDescriptors = artifactClassLoader.getArtifactPluginClassLoaders().stream().map(a -> this.effectiveModel(properties, (ArtifactPluginDescriptor)a.getArtifactDescriptor())).collect(Collectors.toSet());
        ExtensionModelDiscoverer extensionModelDiscoverer = ExtensionModelDiscoverer.defaultExtensionModelDiscoverer((MuleDeployableArtifactClassLoader)artifactClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
        ExtensionDiscoveryRequest request = ExtensionDiscoveryRequest.builder().setArtifactPlugins(artifactPluginDescriptors).setParentArtifactExtensions((Set)ImmutableSet.copyOf(this.loadRuntimeExtensionModels())).build();
        return extensionModelDiscoverer.discoverPluginsExtensionModels(request);
    }

    private ArtifactPluginDescriptor effectiveModel(Map<String, String> properties, ArtifactPluginDescriptor artifactDescriptor) {
        if (Boolean.parseBoolean(properties.getOrDefault("EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", "false"))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Loading effective model for '%s'", artifactDescriptor.getBundleDescriptor()));
            }
            artifactDescriptor.getExtensionModelDescriptorProperty().ifPresent(extensionModelDescriptorProperty -> extensionModelDescriptorProperty.addAttributes((Map)ImmutableMap.of((Object)"EXTENSION_LOADER_DISABLE_COMPONENT_IGNORE", (Object)Boolean.TRUE)));
        }
        return artifactDescriptor;
    }

    private static /* synthetic */ boolean lambda$withTemporaryApplication$4(String file) {
        return file.endsWith(".dwl");
    }

    private static /* synthetic */ boolean lambda$withTemporaryApplication$3(String file) {
        return file.endsWith(".dwl");
    }

    private static /* synthetic */ IllegalStateException lambda$withTemporaryApplication$2(BundleDescriptor pluginDescriptor) {
        return new IllegalStateException(String.format("Couldn't find plugin descriptor: %s", pluginDescriptor));
    }

    private static /* synthetic */ boolean lambda$withTemporaryApplication$1(BundleDescriptor pluginDescriptor, ArtifactClassLoader artifactPluginClassLoader) {
        return artifactPluginClassLoader.getArtifactDescriptor().getBundleDescriptor().getGroupId().equals(pluginDescriptor.getGroupId()) && artifactPluginClassLoader.getArtifactDescriptor().getBundleDescriptor().getArtifactId().equals(pluginDescriptor.getArtifactId());
    }

    private static /* synthetic */ File lambda$withTemporaryApplication$0(File applicationFolder, String empty) {
        return applicationFolder;
    }

    @FunctionalInterface
    static interface TemporaryApplicationFunction {
        public PluginResources call(ArtifactPluginDescriptor var1, MuleDeployableArtifactClassLoader var2, Map<String, String> var3);
    }

    static class PluginFileMavenReactor
    implements MavenReactorResolver {
        private static final String POM_XML = "pom.xml";
        private static final String POM = "pom";
        private final org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor;
        private final File mulePluginJarFile;
        private final File temporaryFolder;

        public PluginFileMavenReactor(org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor descriptor, File mulePluginJarFile, File workingDirectory) {
            this.descriptor = descriptor;
            this.mulePluginJarFile = mulePluginJarFile;
            this.temporaryFolder = new File(workingDirectory, UUID.getUUID());
            this.temporaryFolder.mkdirs();
            Model model = DefaultExtensionModelService.getPomModelFromJar(mulePluginJarFile);
            MavenXpp3Writer writer = new MavenXpp3Writer();
            try (FileOutputStream outputStream = new FileOutputStream(new File(this.temporaryFolder, POM_XML));){
                writer.write((OutputStream)outputStream, model);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        public File findArtifact(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                if (bundleDescriptor.getType().equals(POM)) {
                    return new File(this.temporaryFolder, POM_XML);
                }
                return this.mulePluginJarFile;
            }
            return null;
        }

        public List<String> findVersions(BundleDescriptor bundleDescriptor) {
            if (this.checkArtifact(bundleDescriptor)) {
                return Collections.singletonList(this.descriptor.getVersion());
            }
            return Collections.emptyList();
        }

        private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
            return this.descriptor.getGroupId().equals(bundleDescriptor.getGroupId()) && this.descriptor.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.descriptor.getVersion().equals(bundleDescriptor.getVersion());
        }

        public void dispose() {
            try {
                org.apache.commons.io.FileUtils.deleteDirectory((File)this.temporaryFolder);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

