/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.api;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.Classifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.tooling.api.AstValidatonResult;
import org.mule.tooling.api.ConfigurationException;
import org.mule.tooling.api.ExtensionModelLoader;
import org.mule.tooling.api.ExtensionModelLoaderFactory;
import org.mule.tooling.internal.PluginResources;

public class AstGenerator {
    AstXmlParser xmlParser;

    public AstGenerator(MavenClient mavenClient, String runtimeVersion, Set<Artifact> allDependencies, Path workingDir, ClassRealm classRealm, List<Dependency> directDependencies) {
        this(mavenClient, runtimeVersion, allDependencies, workingDir, classRealm, directDependencies, true, Classifier.MULE_APPLICATION.toString());
    }

    public AstGenerator(MavenClient mavenClient, String runtimeVersion, Set<Artifact> allDependencies, Path workingDir, ClassRealm classRealm, List<Dependency> directDependencies, Boolean asApplication, String classifier) {
        ClassLoader classloader = AstGenerator.class.getClassLoader();
        ExtensionModelLoader loader = ExtensionModelLoaderFactory.createLoader(mavenClient, workingDir, classloader, runtimeVersion);
        HashSet<ExtensionModel> extensionModels = new HashSet<ExtensionModel>();
        ArrayList<URL> dependenciesURL = new ArrayList<URL>();
        for (Dependency dependency2 : directDependencies) {
            this.removeExtModelIfExists(extensionModels, dependency2);
            this.processDependency(dependency2, classloader, mavenClient, runtimeVersion, workingDir, extensionModels, dependenciesURL, loader);
        }
        allDependencies.stream().map(this::createDependency).filter(dependency -> !directDependencies.contains(dependency)).forEach(dependency -> this.processDependency((Dependency)dependency, classloader, mavenClient, runtimeVersion, workingDir, (Set<ExtensionModel>)extensionModels, dependenciesURL, loader));
        dependenciesURL.forEach(url -> {
            try {
                classRealm.addURL(url);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        Set<ExtensionModel> runtimeExtensionModels = loader.getRuntimeExtensionModels();
        extensionModels.addAll(runtimeExtensionModels);
        AstXmlParser.Builder builder = new AstXmlParser.Builder();
        ConfigurationPropertiesHierarchyBuilder emptyPropertyResolverBuilder = new ConfigurationPropertiesHierarchyBuilder();
        if (!asApplication.booleanValue()) {
            builder.withArtifactType(ArtifactType.DOMAIN);
        }
        builder.withExtensionModels(extensionModels);
        if (asApplication.booleanValue() && !Classifier.MULE_PLUGIN.toString().equals(classifier)) {
            ConfigurationPropertiesResolver propertiesResolver = emptyPropertyResolverBuilder.build();
            builder.withPropertyResolver(propertyKey -> (String)propertiesResolver.resolveValue(propertyKey));
        }
        this.xmlParser = builder.build();
    }

    private void removeExtModelIfExists(Set<ExtensionModel> extensionModels, Dependency dependency) {
        extensionModels.removeIf(extension -> extension.getArtifactCoordinates().map(coordinates -> dependency.getArtifactId().equals(coordinates.getArtifactId()) && dependency.getGroupId().equals(coordinates.getGroupId())).orElse(false));
    }

    private Dependency createDependency(Artifact artifact) {
        Dependency dependency = new Dependency();
        dependency.setArtifactId(artifact.getArtifactId());
        dependency.setGroupId(artifact.getGroupId());
        dependency.setVersion(artifact.getVersion());
        if (artifact.getClassifier() != null) {
            dependency.setClassifier(artifact.getClassifier());
        }
        if (artifact.getType() != null) {
            dependency.setType(artifact.getType());
        }
        return dependency;
    }

    private boolean resourceInJar(URL resource) {
        return resource.toExternalForm().startsWith("jar:") && resource.toExternalForm().contains("!/");
    }

    public static BundleDescriptor toBundleDescriptor(Dependency dependency) {
        return new BundleDescriptor.Builder().setGroupId(dependency.getGroupId()).setArtifactId(dependency.getArtifactId()).setVersion(dependency.getVersion()).setBaseVersion(dependency.getVersion()).setClassifier(dependency.getClassifier()).setType(dependency.getType()).build();
    }

    public ArtifactAst generateAST(List<String> configs, Path configsPath) throws FileNotFoundException {
        ArrayList<Pair> appXmlConfigInputStreams = new ArrayList<Pair>();
        for (String config : configs) {
            appXmlConfigInputStreams.add(new Pair((Object)config, (Object)new FileInputStream(configsPath.resolve(config).toFile())));
        }
        return appXmlConfigInputStreams.isEmpty() ? null : this.xmlParser.parse(appXmlConfigInputStreams);
    }

    public void processDependency(Dependency dependency, ClassLoader classloader, MavenClient mavenClient, String runtimeVersion, Path workingDir, Set<ExtensionModel> extensionModels, ArrayList<URL> dependenciesURL, ExtensionModelLoader loader) {
        if (dependency.getClassifier() != null && dependency.getClassifier().equals("mule-plugin")) {
            PluginResources extensionInformation = loader.load(AstGenerator.toBundleDescriptor(dependency));
            extensionModels.addAll(extensionInformation.getExtensionModels());
            extensionInformation.getExportedResources().forEach(resource -> {
                try {
                    if (this.resourceInJar((URL)resource)) {
                        dependenciesURL.add(new URL(resource.toExternalForm().split("!/")[0] + "!/"));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            });
        } else if ("jar".equals(dependency.getType())) {
            try {
                dependenciesURL.add(mavenClient.resolveBundleDescriptor(AstGenerator.toBundleDescriptor(dependency)).getBundleUri().toURL());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public AstValidatonResult validateAST(ArtifactAst artifactAst) throws ConfigurationException {
        artifactAst.updatePropertiesResolver(propertyKey -> propertyKey);
        ValidationResult result = MuleAstUtils.validatorBuilder().ignoreParamsWithProperties(true).build().validate(artifactAst);
        ArrayList<ValidationResultItem> dynamicStructureErrors = new ArrayList<ValidationResultItem>();
        ArrayList<ValidationResultItem> errors = new ArrayList<ValidationResultItem>();
        ArrayList<ValidationResultItem> warnings = new ArrayList<ValidationResultItem>();
        result.getItems().forEach(v -> {
            if (v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)) {
                if (v.causedByDynamicArtifact()) {
                    dynamicStructureErrors.add((ValidationResultItem)v);
                } else {
                    errors.add((ValidationResultItem)v);
                }
            } else {
                warnings.add((ValidationResultItem)v);
            }
        });
        if (errors.size() > 0) {
            throw new ConfigurationException(((ValidationResultItem)errors.get(0)).getMessage());
        }
        return new AstValidatonResult(errors, warnings, dynamicStructureErrors);
    }

    public static InputStream serialize(ArtifactAst artifactAst) {
        return new ArtifactAstSerializerProvider().getSerializer("JSON", "1.0").serialize(artifactAst);
    }
}

