/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller.probing;

import org.mule.tools.client.standalone.controller.probing.Probe;
import org.mule.tools.client.standalone.controller.probing.Prober;
import org.mule.tools.client.standalone.controller.probing.Timeout;

public class PollingProber
implements Prober {
    private static final long DEFAULT_TIMEOUT = 1000L;
    private static final long DEFAULT_POLLING_INTERVAL = 100L;
    private final long timeoutMillis;
    private final long pollDelayMillis;

    public PollingProber(Long timeoutMillis, Long pollDelayMillis) {
        this.timeoutMillis = timeoutMillis == null ? 1000L : timeoutMillis;
        this.pollDelayMillis = pollDelayMillis == null ? 100L : pollDelayMillis;
    }

    @Override
    public void check(Probe probe) {
        if (!this.poll(probe)) {
            throw new AssertionError((Object)probe.describeFailure());
        }
    }

    private boolean poll(Probe probe) {
        Timeout timeout = new Timeout(this.timeoutMillis);
        while (!probe.isSatisfied()) {
            if (timeout.hasTimedOut()) {
                return false;
            }
            this.waitFor(this.pollDelayMillis);
        }
        return true;
    }

    private void waitFor(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("unexpected interrupt", e);
        }
    }
}

