/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.fabric;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.DeploymentModify;
import org.mule.tools.client.fabric.model.Target;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.deployment.fabric.RequestBuilder;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.fabric.RuntimeFabricDeploymentVerification;

public class RuntimeFabricArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_RUNTIME_FABRIC_DEPLOYMENT_TIMEOUT = 1200000L;
    private DeploymentVerification deploymentVerification;
    private RequestBuilder requestBuilder;
    protected RuntimeFabricClient client;
    private final DeployerLog log;
    protected final RuntimeFabricDeployment deployment;

    public RuntimeFabricArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new RuntimeFabricClient((RuntimeFabricDeployment)deployment, log), log);
    }

    protected RuntimeFabricArtifactDeployer(Deployment deployment, RuntimeFabricClient client, DeployerLog log) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"The client must not be null.");
        this.log = log;
        this.client = client;
        this.deployment = (RuntimeFabricDeployment)deployment;
        this.deploymentVerification = new RuntimeFabricDeploymentVerification(client);
        this.requestBuilder = this.createRequestBuilder();
        if (!this.deployment.getDeploymentTimeout().isPresent()) {
            this.deployment.setDeploymentTimeout(DEFAULT_RUNTIME_FABRIC_DEPLOYMENT_TIMEOUT);
        }
    }

    public RequestBuilder createRequestBuilder() {
        return new RequestBuilder(this.deployment, this.client);
    }

    @Override
    public void deployApplication() throws DeploymentException {
        try {
            this.log.info("Starting deployment to " + this.deployment.getTarget());
            this.log.info("Checking app " + this.deployment.getApplicationName());
            DeploymentModify modify = this.requestBuilder.buildDeploymentModify();
            Optional<String> deploymentId = this.requestBuilder.getOptionalDeploymentId(modify.target);
            if (deploymentId.isPresent()) {
                this.client.redeploy(modify, deploymentId.get());
            } else {
                this.client.deploy(this.requestBuilder.buildDeploymentRequest());
            }
        }
        catch (ClientException e) {
            throw new DeploymentException("Could not deploy application.", e);
        }
        if (!this.deployment.getSkipDeploymentVerification().booleanValue()) {
            this.checkApplicationHasStarted();
        }
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        try {
            Target target = this.requestBuilder.buildTarget();
            String deploymentId = this.requestBuilder.getDeploymentId(target);
            this.client.deleteDeployment(deploymentId);
        }
        catch (IllegalStateException | ClientException e) {
            throw new DeploymentException("Could not undeploy application.", e);
        }
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to Runtime Fabric is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Undeployment of domains to Runtime Fabric is not supported");
    }

    public void setDeploymentVerification(DeploymentVerification deploymentVerification) {
        Preconditions.checkArgument((deploymentVerification != null ? 1 : 0) != 0, (Object)"The verificator must not be null.");
        this.deploymentVerification = deploymentVerification;
    }

    public void setRequestBuilder(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking if application: " + this.deployment.getApplicationName() + " has started");
        this.deploymentVerification.assertDeployment(this.deployment);
    }
}

