/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.standalone.controller;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.mule.tools.client.standalone.controller.AbstractOSController;
import org.mule.tools.client.standalone.exception.MuleControllerException;

public class Controller {
    protected static final String ANCHOR_SUFFIX = "-anchor.txt";
    private static final IOFileFilter ANCHOR_FILTER = FileFilterUtils.suffixFileFilter((String)"-anchor.txt");
    private static final String DOMAIN_DEPLOY_ERROR = "Error deploying domain %s.";
    private static final String ANCHOR_DELETE_ERROR = "Could not delete anchor file [%s] when stopping Mule Runtime.";
    private static final String ADD_LIBRARY_ERROR = "Error copying jar file [%s] to lib directory [%s].";
    private static final int IS_RUNNING_STATUS_CODE = 0;
    private static final Pattern pattern = Pattern.compile("wrapper\\.java\\.additional\\.(\\d*)=");
    private final AbstractOSController osSpecificController;
    protected File serverPluginsDir;
    protected File domainsDir;
    protected File appsDir;
    protected File libsDir;
    protected File internalRepository;
    protected Path wrapperConf;

    public Controller(AbstractOSController osSpecificController, String muleHome) {
        this.osSpecificController = osSpecificController;
        this.serverPluginsDir = new File(muleHome + "/server-plugins");
        this.domainsDir = new File(muleHome + "/domains");
        this.appsDir = new File(muleHome + "/apps/");
        this.libsDir = new File(muleHome + "/lib/user");
        this.internalRepository = new File(muleHome, "repository");
        this.wrapperConf = Paths.get(muleHome + "/conf/wrapper.conf", new String[0]);
    }

    public String getMuleBin() {
        return this.osSpecificController.getMuleBin();
    }

    public void start(String ... args) {
        this.checkRepositoryLocationAndUpdateInternalRepoPropertyIfPresent(args);
        this.osSpecificController.start(args);
    }

    protected void checkRepositoryLocationAndUpdateInternalRepoPropertyIfPresent(String ... args) {
        Arrays.stream(args).filter(arg -> arg.contains("-M-DmuleRuntimeConfig.maven.repositoryLocation=")).findFirst().ifPresent(repo -> {
            this.internalRepository = new File(repo.split("=")[1]);
        });
    }

    public int stop(String ... args) {
        int error = this.osSpecificController.stop(args);
        this.verify(error == 0, "The mule instance couldn't be stopped", new Object[0]);
        this.deleteAnchors();
        return error;
    }

    public int status(String ... args) {
        return this.osSpecificController.status(args);
    }

    public int getProcessId() {
        return this.osSpecificController.getProcessId();
    }

    public void restart(String ... args) {
        this.osSpecificController.restart(args);
    }

    protected void verify(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new MuleControllerException(String.format(message, args));
        }
    }

    protected void deployDomain(String domain) {
        File domainFile = new File(domain);
        this.verify(domainFile.exists(), "Domain does not exist: %s", domain);
        try {
            if (domainFile.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)domainFile, (File)this.domainsDir);
            } else {
                FileUtils.copyFileToDirectory((File)domainFile, (File)this.domainsDir);
            }
        }
        catch (IOException e) {
            throw new MuleControllerException(String.format(DOMAIN_DEPLOY_ERROR, domain), e);
        }
    }

    protected void addLibrary(File jar) {
        this.verify(jar.exists(), "Jar file does not exist: %s", jar);
        this.verify("jar".equals(FilenameUtils.getExtension((String)jar.getAbsolutePath())), "Library [%s] don't have .jar extension.", jar);
        this.verify(jar.canRead(), "Cannot read jar file: %s", jar);
        this.verify(this.libsDir.canWrite(), "Cannot write on lib dir: %s", this.libsDir);
        try {
            FileUtils.copyFileToDirectory((File)jar, (File)this.libsDir);
        }
        catch (IOException e) {
            throw new MuleControllerException(String.format(ADD_LIBRARY_ERROR, jar, this.libsDir), e);
        }
    }

    protected void deleteAnchors() {
        Collection anchors = FileUtils.listFiles((File)this.appsDir, (IOFileFilter)ANCHOR_FILTER, null);
        for (File anchor : anchors) {
            try {
                FileUtils.forceDelete((File)anchor);
            }
            catch (IOException e) {
                throw new MuleControllerException(String.format(ANCHOR_DELETE_ERROR, anchor), e);
            }
        }
    }

    public void deploy(String path) {
        File app = new File(path);
        this.verify(app.exists(), "File does not exists: %s", app);
        this.verify(app.canRead(), "Cannot read file: %s", app);
        try {
            if (app.isFile()) {
                FileUtils.copyFileToDirectory((File)app, (File)this.appsDir);
            } else {
                FileUtils.copyDirectoryToDirectory((File)app, (File)this.appsDir);
            }
        }
        catch (IOException e) {
            throw new MuleControllerException("Could not deploy app [" + path + "] to [" + this.appsDir + "]", e);
        }
    }

    public boolean isRunning() {
        return 0 == this.status(new String[0]);
    }

    public void undeploy(String application) {
        if (!new File(this.appsDir, application + ANCHOR_SUFFIX).exists()) {
            throw new MuleControllerException("Couldn't undeploy application [" + application + "]. Application is not deployed");
        }
        if (!new File(this.appsDir, application + ANCHOR_SUFFIX).delete()) {
            throw new MuleControllerException("Couldn't undeploy application [" + application + "]");
        }
    }

    public void undeployDomain(String domain) {
        if (!new File(this.domainsDir, domain + ANCHOR_SUFFIX).exists()) {
            throw new MuleControllerException("Couldn't undeploy domain [" + domain + "]. Domain is not deployed");
        }
        if (!new File(this.domainsDir, domain + ANCHOR_SUFFIX).delete()) {
            throw new MuleControllerException("Couldn't undeploy domain [" + domain + "]");
        }
    }

    public void undeployAll() {
        for (File file : Objects.requireNonNull(this.appsDir.listFiles())) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                throw new MuleControllerException("Could not delete directory [" + file.getAbsolutePath() + "]", e);
            }
        }
    }

    public void installLicense(String path) {
        if (0 != this.osSpecificController.runSync(null, "--installLicense", path, "-M-client")) {
            throw new MuleControllerException("Could not install license " + path);
        }
    }

    public void uninstallLicense() {
        if (0 != this.osSpecificController.runSync(null, "--unInstallLicense", "-M-client")) {
            throw new MuleControllerException("Could not uninstall license");
        }
    }

    protected boolean isDeployed(String appName) {
        return new File(this.appsDir, appName + ANCHOR_SUFFIX).exists();
    }

    protected boolean isDomainDeployed(String domainName) {
        return new File(this.domainsDir, domainName + ANCHOR_SUFFIX).exists();
    }

    protected File getArtifactInternalRepository(String artifactName) {
        return new File(new File(this.appsDir, artifactName), "repository");
    }

    protected File getRuntimeInternalRepository() {
        return this.internalRepository;
    }

    public File getLog() {
        File logEE = new File(this.osSpecificController.getMuleHome() + "/logs/mule_ee.log");
        File logCE = new File(this.osSpecificController.getMuleHome() + "/logs/mule.log");
        if (logCE.exists() && logCE.isFile()) {
            return logCE;
        }
        if (logEE.exists() && logEE.isFile()) {
            return logEE;
        }
        throw new MuleControllerException(String.format("There is no mule log available at %s/logs/", this.osSpecificController.getMuleHome()));
    }

    public File getLog(String appName) {
        File log = new File(String.format("%s/logs/mule-app-%s.log", this.osSpecificController.getMuleHome(), appName));
        if (log.exists() && log.isFile()) {
            return log;
        }
        throw new MuleControllerException(String.format("There is no app log available at %s/logs/mule-app-%s", this.osSpecificController.getMuleHome(), appName));
    }

    public void addConfProperty(String value) {
        try {
            int maxOrder = this.getMaxPropertyOrder(this.wrapperConf);
            String line = String.format("wrapper.java.additional.%d=%s\n", maxOrder + 1, value);
            Files.write(this.wrapperConf, line.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Couldn't add wrapper.conf property", e);
        }
    }

    private int getOrderNumber(String line) {
        Matcher matcher = pattern.matcher(line);
        matcher.find();
        return Integer.parseInt(matcher.group(1));
    }

    private Integer getMaxPropertyOrder(Path path) throws IOException {
        return Files.lines(path).filter(line -> pattern.matcher((CharSequence)line).find()).map(this::getOrderNumber).max(Integer::compare).get();
    }
}

