/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.client.core;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.glassfish.jersey.apache5.connector.Apache5ConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jdk.connector.JdkConnectorProvider;
import org.glassfish.jersey.media.multipart.Boundary;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.logging.ClientLoggingFilter;
import org.mule.tools.utils.DeployerLog;

public abstract class AbstractClient {
    private String userAgent = "mule-deployer%s";
    protected DeployerLog log;
    protected static final String CONNECTOR_PROVIDER_PROPERTY = "connectorProvider";
    protected static final String APACHE_5 = "apache";
    protected static final String HTTP_URL = "http";
    protected static final String JDK = "jdk";
    protected static final String HTTP_PROXY_URI = "http.proxyUri";
    protected static final String HTTP_PROXY_USER = "http.proxyUser";
    protected static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    protected static final String HTTP_PROXY_PORT = "http.proxyPort";
    protected static final String HTTP_PROXY_HOST = "http.proxyHost";
    private boolean isClientInitialized = false;
    private Consumer<ClientBuilder> clientBuilderConfigurer;
    private Long readEntityTimeout;

    public AbstractClient() {
    }

    public AbstractClient(DeployerLog log) {
        this.log = log;
    }

    protected Response post(String uri, String path, Entity entity) {
        this.initialize();
        return this.doRequest(this.builder(uri, path), entity, SyncInvoker::post);
    }

    protected Response post(String uri, String path, Object entity) {
        this.initialize();
        return this.post(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response post(String uri, Supplier<String> pathSupplier, Object entity) {
        this.initialize();
        return this.post(uri, pathSupplier.get(), Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response put(String uri, String path, Entity entity) {
        this.initialize();
        return this.doRequest(this.builder(uri, path), entity, SyncInvoker::put);
    }

    protected Response put(String uri, String path, Object entity) {
        this.initialize();
        return this.put(uri, path, Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response delete(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).delete();
    }

    protected Response get(String uri, String path) {
        this.initialize();
        return this.builder(uri, path).get();
    }

    protected Response get(String uri, Supplier<String> pathSupplier) {
        this.initialize();
        return this.builder(uri, pathSupplier.get()).get();
    }

    protected Response delete(String uri, Supplier<String> pathSupplier) {
        this.initialize();
        return this.builder(uri, pathSupplier.get()).delete();
    }

    protected <T> T get(String uri, String path, Class<T> clazz) {
        this.initialize();
        return (T)this.readEntityWithTimeout(() -> this.get(uri, path).readEntity(clazz));
    }

    protected Response patch(String uri, Supplier<String> path, Object entity) {
        this.initialize();
        return this.patch(uri, path.get(), Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected Response patch(String uri, String path, Entity entity) {
        this.initialize();
        Invocation.Builder builder = this.builder(uri, path);
        return this.doRequest(this.builder(uri, path), entity, (currentBuilder, currentEntity) -> currentBuilder.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true).method("PATCH", currentEntity));
    }

    private Response doRequest(Invocation.Builder builder, Entity entity, BiFunction<Invocation.Builder, Entity, Response> action) {
        if (entity != null && entity.getEntity() instanceof FormDataMultiPart) {
            MediaType boundaryMediaType = Boundary.addBoundary((MediaType)entity.getMediaType());
            ((FormDataMultiPart)entity.getEntity()).setMediaType(boundaryMediaType);
            builder.header("Content-Type", (Object)boundaryMediaType.toString());
            builder.header("MIME-Version", (Object)"1.0");
            return action.apply(builder, Entity.entity((Object)entity.getEntity(), (MediaType)boundaryMediaType));
        }
        return action.apply(builder, entity);
    }

    protected <T> T readEntityWithTimeout(Supplier<T> supplier) {
        if (this.readEntityTimeout == null || this.readEntityTimeout < 1L) {
            return supplier.get();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Object> future = executorService.submit(supplier::get);
            Object response = future.get(this.readEntityTimeout, TimeUnit.MILLISECONDS);
            executorService.shutdownNow();
            return (T)response;
        }
        catch (Exception e) {
            executorService.shutdownNow();
            throw new RuntimeException(e);
        }
    }

    public synchronized void initialize() {
        if (!this.isClientInitialized) {
            this.isClientInitialized = true;
            this.init();
        }
    }

    protected abstract void init();

    private Invocation.Builder builder(String uri, String path) {
        WebTarget target = this.getTarget(uri, path);
        Invocation.Builder builder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("User-Agent", (Object)this.getUserAgent());
        this.setBuilderProperties(builder);
        this.configureRequest(builder);
        return builder;
    }

    public void setClientBuilderConfigurer(Consumer<ClientBuilder> clientBuilderConfigurer) {
        this.clientBuilderConfigurer = clientBuilderConfigurer;
    }

    public void setReadEntityTimeout(Long readEntityTimeout) {
        this.readEntityTimeout = readEntityTimeout;
    }

    protected WebTarget getTarget(String uri, String path) {
        ClientConfig configuration = new ClientConfig();
        String connector = System.getProperty(CONNECTOR_PROVIDER_PROPERTY, APACHE_5);
        this.setProxyProperties(connector, configuration);
        switch (connector) {
            case "jdk": {
                configuration.connectorProvider((ConnectorProvider)new JdkConnectorProvider());
                break;
            }
            case "apache": {
                configuration.connectorProvider((ConnectorProvider)new Apache5ConnectorProvider());
                break;
            }
            case "http": {
                configuration.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider());
            }
        }
        ClientBuilder builder = ClientBuilder.newBuilder().withConfig((Configuration)configuration);
        Optional.ofNullable(this.clientBuilderConfigurer).ifPresent(configurer -> configurer.accept(builder));
        this.configureSecurityContext(builder);
        Client client = (Client)builder.build().register(MultiPartFeature.class);
        if (this.log != null && this.log.isDebugEnabled() && !this.isLoginRequest(path)) {
            client.register((Object)new ClientLoggingFilter(this.log));
        }
        return client.target(uri).path(path);
    }

    protected void setProxyProperties(String connector, ClientConfig configuration) {
        Optional<String> user = Optional.ofNullable(System.getProperty(HTTP_PROXY_USER));
        Optional<String> pass = Optional.ofNullable(System.getProperty(HTTP_PROXY_PASSWORD));
        if (APACHE_5.equals(connector)) {
            Optional<String> host = Optional.ofNullable(System.getProperty(HTTP_PROXY_HOST));
            Optional<String> port = Optional.ofNullable(System.getProperty(HTTP_PROXY_PORT));
            if (host.isPresent() && port.isPresent()) {
                RequestConfig.Builder requestConfig = RequestConfig.custom();
                HttpHost httpHost = new HttpHost(host.get(), Integer.parseInt(port.get()));
                requestConfig.setProxy(httpHost);
                configuration.property("jersey.config.apache5.client.requestConfig", (Object)requestConfig.build());
                if (user.isPresent() && pass.isPresent()) {
                    CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(user.get(), pass.get().toCharArray())).build();
                    configuration.property("jersey.config.apache5.client.credentialsProvider", (Object)credentialsProvider);
                }
            }
        }
    }

    private boolean isLoginRequest(String path) {
        return "/accounts/login".equals(path);
    }

    protected String getUserAgent() {
        Package classPackage = AbstractClient.class.getPackage();
        String implementationVersion = classPackage != null ? classPackage.getImplementationVersion() : "";
        String version = StringUtils.isNotBlank((CharSequence)implementationVersion) ? "/" + implementationVersion : "";
        return String.format(this.userAgent, version);
    }

    protected void configureRequest(Invocation.Builder builder) {
    }

    protected void configureSecurityContext(ClientBuilder builder) {
    }

    protected void checkResponseStatus(Response response) {
        if (Response.Status.Family.familyOf((int)response.getStatus()) != Response.Status.Family.SUCCESSFUL) {
            throw new ClientException(response, this.readEntityWithTimeout(() -> (String)response.readEntity(String.class)));
        }
    }

    protected void checkResponseStatus(Response response, Response.Status ... expectedStatus) {
        ArrayList<Integer> success = new ArrayList<Integer>();
        for (Response.Status s : expectedStatus) {
            success.add(s.getStatusCode());
        }
        Integer statusCode = response.getStatus();
        if (!success.contains(statusCode)) {
            throw new ClientException(response, this.readEntityWithTimeout(() -> (String)response.readEntity(String.class)));
        }
    }

    protected <T> T readJsonEntity(Response response, Type type) {
        String jsonResponse = this.readEntityWithTimeout(() -> (String)response.readEntity(String.class));
        return (T)new Gson().fromJson(jsonResponse, type);
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    private void setBuilderProperties(Invocation.Builder builder) {
        builder.property("jersey.config.client.request.entity.processing", (Object)"CHUNKED");
        builder.property("jersey.config.client.chunkedEncodingSize", (Object)4096);
    }
}

