/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.fabric;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.mule.tools.client.core.exception.ClientException;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.client.fabric.RuntimeFabricClient;
import org.mule.tools.client.fabric.model.DeploymentModify;
import org.mule.tools.client.fabric.model.DeploymentRequest;
import org.mule.tools.client.fabric.model.Target;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.deployment.fabric.RequestBuilder;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.RuntimeFabricDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.fabric.RuntimeFabricDeploymentVerification;

public class RuntimeFabricArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_RUNTIME_FABRIC_DEPLOYMENT_TIMEOUT = 1200000L;
    private static final String RTF_DEPLOY_ERROR_MESSAGE = "This target has an application with the same name already deployed. Please delete it in order to create a new deployment.";
    public static final int BAD_REQUEST = 400;
    private DeploymentVerification deploymentVerification;
    private RequestBuilder requestBuilder;
    protected RuntimeFabricClient client;
    private final DeployerLog log;
    protected final RuntimeFabricDeployment deployment;

    public RuntimeFabricArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new RuntimeFabricClient((RuntimeFabricDeployment)deployment, log), log);
    }

    protected RuntimeFabricArtifactDeployer(Deployment deployment, RuntimeFabricClient client, DeployerLog log) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"The client must not be null.");
        this.log = log;
        this.client = client;
        this.deployment = (RuntimeFabricDeployment)deployment;
        this.deploymentVerification = new RuntimeFabricDeploymentVerification(client);
        this.requestBuilder = this.createRequestBuilder();
        if (!this.deployment.getDeploymentTimeout().isPresent()) {
            this.deployment.setDeploymentTimeout(DEFAULT_RUNTIME_FABRIC_DEPLOYMENT_TIMEOUT);
        }
    }

    public RequestBuilder createRequestBuilder() {
        return new RequestBuilder(this.deployment, this.client);
    }

    @Override
    public void deployApplication() throws DeploymentException {
        try {
            this.log.info("Starting deployment to " + this.deployment.getTarget());
            DeploymentRequest request = this.requestBuilder.buildDeploymentRequest();
            this.client.deploy(request);
        }
        catch (ClientException e) {
            if (this.isAlreadyDeployed(e)) {
                this.redeployApplication();
            }
            throw new DeploymentException("Could not deploy application.", e);
        }
        if (!this.deployment.getSkipDeploymentVerification().booleanValue()) {
            this.checkApplicationHasStarted();
        }
    }

    protected boolean isAlreadyDeployed(ClientException e) {
        return e.getStatusCode() == 400 && StringUtils.containsIgnoreCase((CharSequence)e.getMessage(), (CharSequence)RTF_DEPLOY_ERROR_MESSAGE);
    }

    private void redeployApplication() throws DeploymentException {
        try {
            DeploymentModify modify = this.requestBuilder.buildDeploymentModify();
            String deploymentId = this.requestBuilder.getDeploymentId(modify.target);
            this.client.redeploy(modify, deploymentId);
        }
        catch (IllegalStateException e) {
            throw new DeploymentException("Could not redeploy application.", e);
        }
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        try {
            Target target = this.requestBuilder.buildTarget();
            String deploymentId = this.requestBuilder.getDeploymentId(target);
            this.client.deleteDeployment(deploymentId);
        }
        catch (IllegalStateException | ClientException e) {
            throw new DeploymentException("Could not undeploy application.", e);
        }
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to Runtime Fabric is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Undeployment of domains to Runtime Fabric is not supported");
    }

    public void setDeploymentVerification(DeploymentVerification deploymentVerification) {
        Preconditions.checkArgument((deploymentVerification != null ? 1 : 0) != 0, (Object)"The verificator must not be null.");
        this.deploymentVerification = deploymentVerification;
    }

    public void setRequestBuilder(RequestBuilder requestBuilder) {
        this.requestBuilder = requestBuilder;
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking if application: " + this.deployment.getApplicationName() + " has started");
        this.deploymentVerification.assertDeployment(this.deployment);
    }
}

