/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.arm;

import javax.ws.rs.NotFoundException;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.Deployer;
import org.mule.tools.deployment.arm.ArmArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.utils.DeployerLog;

public class ArmApplicationDeployer
implements Deployer {
    private final ArmArtifactDeployer armArtifactDeployer;
    private final DeployerLog log;

    public ArmApplicationDeployer(Deployment deployment, DeployerLog log) throws DeploymentException {
        this(new ArmArtifactDeployer(deployment, log), log);
    }

    protected ArmApplicationDeployer(ArmArtifactDeployer deployer, DeployerLog log) {
        this.armArtifactDeployer = deployer;
        this.log = log;
    }

    @Override
    public void deploy() throws DeploymentException {
        Integer applicationId = this.armArtifactDeployer.getApplicationId();
        if (applicationId == null) {
            this.armArtifactDeployer.deployApplication();
        } else {
            this.armArtifactDeployer.redeployApplication();
        }
    }

    @Override
    public void undeploy() throws DeploymentException {
        try {
            this.armArtifactDeployer.undeployApplication();
        }
        catch (NotFoundException e) {
            if (this.armArtifactDeployer.isFailIfNotExists()) {
                throw e;
            }
            this.log.error("Application not found: " + this.armArtifactDeployer.getApplicationName());
        }
    }
}

