/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.model.anypoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.model.anypoint.AnypointDeployment;

public class CloudHubDeployment
extends AnypointDeployment {
    @Parameter
    protected Integer workers;
    @Parameter
    protected String workerType;
    @Parameter
    protected String region;
    @Parameter
    protected Map<String, String> properties = new HashMap<String, String>();

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Optional<Integer> getWorkers() {
        return Optional.ofNullable(this.workers);
    }

    public void setWorkers(Integer workers) {
        this.workers = workers;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public void setWorkerType(String workerType) {
        this.workerType = workerType;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public void setEnvironmentSpecificValues() throws DeploymentException {
        String cloudHubWorkerType;
        super.setEnvironmentSpecificValues();
        String cloudHubWorkers = System.getProperty("cloudhub.workers");
        if (StringUtils.isNotBlank((CharSequence)cloudHubWorkers)) {
            this.setWorkers(Integer.valueOf(cloudHubWorkers));
        }
        if (!this.getWorkers().isPresent()) {
            this.setWorkers(Integer.valueOf("1"));
        }
        if (StringUtils.isNotBlank((CharSequence)(cloudHubWorkerType = System.getProperty("cloudhub.workerType")))) {
            this.setWorkerType(cloudHubWorkerType);
        }
        if (StringUtils.isBlank((CharSequence)this.getWorkerType())) {
            this.setWorkerType("Micro");
        }
    }
}

