/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.deployment.arm;

import com.google.common.base.Preconditions;
import org.mule.tools.client.arm.ApplicationMetadata;
import org.mule.tools.client.arm.ArmClient;
import org.mule.tools.client.core.exception.DeploymentException;
import org.mule.tools.deployment.artifact.ArtifactDeployer;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.ArmDeployment;
import org.mule.tools.utils.DeployerLog;
import org.mule.tools.verification.DeploymentVerification;
import org.mule.tools.verification.arm.ArmDeploymentVerification;

public class ArmArtifactDeployer
implements ArtifactDeployer {
    private static final Long DEFAULT_ARM_DEPLOYMENT_TIMEOUT = 1200000L;
    private ArmClient client;
    private final DeployerLog log;
    private Integer applicationId;
    private final ArmDeployment deployment;

    public ArmArtifactDeployer(Deployment deployment, DeployerLog log) {
        this(deployment, new ArmClient(deployment, log), log);
    }

    protected ArmArtifactDeployer(Deployment deployment, ArmClient client, DeployerLog log) {
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"The client must not be null.");
        this.log = log;
        this.client = client;
        this.deployment = (ArmDeployment)deployment;
        if (this.deployment.getDeploymentTimeout() == null) {
            this.deployment.setDeploymentTimeout(DEFAULT_ARM_DEPLOYMENT_TIMEOUT);
        }
    }

    public ApplicationMetadata getApplicationMetadata() {
        return new ApplicationMetadata(this.deployment.getArtifact(), this.deployment.getApplicationName(), this.deployment.getTargetType(), this.deployment.getTarget(), this.deployment.getProperties());
    }

    public boolean isFailIfNotExists() {
        Boolean isFailIfNotExists = this.deployment.isFailIfNotExists();
        return isFailIfNotExists != null ? isFailIfNotExists : true;
    }

    @Override
    public void deployDomain() throws DeploymentException {
        throw new DeploymentException("Deployment of domains to ARM is not supported");
    }

    @Override
    public void undeployDomain() throws DeploymentException {
        throw new DeploymentException("Undeployment of domains to ARM is not supported");
    }

    @Override
    public void deployApplication() throws DeploymentException {
        this.client.deployApplication(this.getApplicationMetadata());
        if (!this.deployment.getSkipDeploymentVerification().booleanValue()) {
            this.checkApplicationHasStarted();
        }
    }

    protected void checkApplicationHasStarted() throws DeploymentException {
        this.log.info("Checking application: " + this.deployment.getApplicationName() + " has started");
        DeploymentVerification verification = this.getDeploymentVerification();
        verification.assertDeployment(this.deployment);
    }

    @Override
    public void undeployApplication() throws DeploymentException {
        this.client.undeployApplication(this.getApplicationMetadata());
    }

    public void redeployApplication() {
        this.log.info("Found " + this.getApplicationMetadata().toString() + ". Redeploying application...");
        this.client.redeployApplication(this.getApplicationId(), this.getApplicationMetadata());
    }

    public Integer getApplicationId() {
        if (this.applicationId == null) {
            this.applicationId = this.client.findApplicationId(this.getApplicationMetadata());
        }
        return this.applicationId;
    }

    protected String getApplicationName() {
        return this.deployment.getApplicationName();
    }

    public DeploymentVerification getDeploymentVerification() {
        return new ArmDeploymentVerification(this.client, this.getApplicationId());
    }
}

