/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.mule.tools.api.classloader.AppClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.ArtifactCustomJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;

public class ClassLoaderModelJsonSerializer {
    public static ClassLoaderModel deserialize(File classLoaderModelDescriptor) {
        try {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().create();
            FileReader reader = new FileReader(classLoaderModelDescriptor);
            ClassLoaderModel classLoaderModel = (ClassLoaderModel)gson.fromJson((Reader)reader, ClassLoaderModel.class);
            ((Reader)reader).close();
            return classLoaderModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    @Deprecated
    public static String serialize(ClassLoaderModel classLoaderModel) {
        return ClassLoaderModelJsonSerializer.serialize(classLoaderModel, true);
    }

    public static String serialize(ClassLoaderModel classLoaderModel, boolean prettyPrinting) {
        GsonBuilder gsonBuilder = new GsonBuilder().enableComplexMapKeySerialization();
        if (prettyPrinting) {
            gsonBuilder = gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.registerTypeAdapter(Artifact.class, (Object)new ArtifactCustomJsonSerializer()).registerTypeAdapter(AppClassLoaderModel.class, (Object)new AppClassLoaderModelJsonSerializer.AppClassLoaderModelCustomJsonSerializer()).registerTypeAdapter(ClassLoaderModel.class, (Object)new ClassLoaderModelCustomJsonSerializer()).create();
        ClassLoaderModel parameterizedClassloaderModel = classLoaderModel.getParametrizedUriModel();
        return gson.toJson((Object)parameterizedClassloaderModel);
    }

    public static File serializeToFile(ClassLoaderModel classLoaderModel, File destinationFolder) {
        return ClassLoaderModelJsonSerializer.serializeToFile(classLoaderModel, destinationFolder, true);
    }

    public static File serializeToFile(ClassLoaderModel classLoaderModel, File destinationFolder, boolean prettyPrinting) {
        File destinationFile = new File(destinationFolder, "classloader-model.json");
        try {
            if (!destinationFolder.exists()) {
                destinationFolder.mkdirs();
            }
            destinationFile.createNewFile();
            FileWriter writer = new FileWriter(destinationFile.getAbsolutePath());
            writer.write(ClassLoaderModelJsonSerializer.serialize(classLoaderModel, prettyPrinting));
            ((Writer)writer).close();
            return destinationFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    private static class ClassLoaderModelCustomJsonSerializer
    implements JsonSerializer<ClassLoaderModel> {
        private ClassLoaderModelCustomJsonSerializer() {
        }

        public JsonElement serialize(ClassLoaderModel classLoaderModel, Type type, JsonSerializationContext jsonSerializationContext) {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter(Artifact.class, (Object)new ArtifactCustomJsonSerializer()).create();
            JsonObject jsonObject = (JsonObject)gson.toJsonTree((Object)classLoaderModel);
            if (classLoaderModel.getPackages() == null || classLoaderModel.getPackages().length == 0) {
                jsonObject.remove("packages");
            }
            if (classLoaderModel.getResources() == null || classLoaderModel.getResources().length == 0) {
                jsonObject.remove("resources");
            }
            return jsonObject;
        }
    }
}

