/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void compressDirectoryContent(String sourcePath, String zipFilePath) throws IOException {
        File source = new File(sourcePath);
        if (source.isDirectory()) {
            FileOutputStream fileOutStream = new FileOutputStream(zipFilePath);
            ZipOutputStream zipOutStream = new ZipOutputStream(fileOutStream);
            ZipUtils.zipDirectoryContent(source, "", zipOutStream);
            zipOutStream.close();
            fileOutStream.close();
        }
    }

    private static void zipDirectoryContent(File directory, String relativePath, ZipOutputStream zipOut) throws IOException {
        File[] children;
        if (directory.isHidden()) {
            return;
        }
        for (File child : children = directory.listFiles()) {
            if (child.isDirectory()) {
                String childRelativePath = relativePath + child.getName() + "/";
                ZipUtils.putDirectoryEntry(childRelativePath, zipOut);
                ZipUtils.zipDirectoryContent(child, childRelativePath, zipOut);
                continue;
            }
            ZipUtils.zipFile(child, relativePath + child.getName(), zipOut);
        }
    }

    private static void putDirectoryEntry(String relativePath, ZipOutputStream zipOut) throws IOException {
        zipOut.putNextEntry(new ZipEntry(relativePath));
        zipOut.closeEntry();
    }

    private static void zipFile(File file, String relativePath, ZipOutputStream zipOut) throws IOException {
        if (file.isHidden()) {
            return;
        }
        zipOut.putNextEntry(new ZipEntry(relativePath));
        ZipUtils.writeFileEntry(file, zipOut);
        zipOut.closeEntry();
    }

    private static void writeFileEntry(File file, ZipOutputStream zipOut) throws IOException {
        int length;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] bytes = new byte[1024];
        while ((length = fileInputStream.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fileInputStream.close();
    }
}

