/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeUriChecker {
    private static final String exchangeAnypointDomain = "https://.*anypoint\\.mulesoft\\.com";
    private static final String exchangeRepositoryBasePath = "/api/v[1-3]/organizations/(.+)/maven$";
    private static final String exchangeV3RepositoryBasePath = "/api/v3/organizations/(.*)/maven$";
    private static final String exchangeV3RepositoryWithoutOrganizationIdBasePath = "/api/v3/maven$";
    private static final String exchangeV3RunIdRepositoryUriBasePath = "/api/v3/organizations/(.+)/maven/runId/(.+)$";
    private final Pattern anypointPrefixUriPattern = Pattern.compile("^https://maven\\.(.*anypoint\\.mulesoft\\.com/)");
    private List<Pattern> exchangeRepositoryUriPatterns;
    private List<Pattern> exchangeV3RepositoryUriPatterns;
    private List<Pattern> exchangeV3RepositoryUriWithoutOrganizationPatterns;
    private List<Pattern> exchangeV3RunIdRepositoryUriPatterns;
    private List<String> customDomains;

    public ExchangeUriChecker() {
        this(new ArrayList<String>());
    }

    public ExchangeUriChecker(List<String> customDomains) {
        this.customDomains = customDomains;
        this.exchangeRepositoryUriPatterns = this.getPatterns(exchangeRepositoryBasePath);
        this.exchangeV3RepositoryUriPatterns = this.getPatterns(exchangeV3RepositoryBasePath);
        this.exchangeV3RepositoryUriWithoutOrganizationPatterns = this.getPatterns(exchangeV3RepositoryWithoutOrganizationIdBasePath);
        this.exchangeV3RunIdRepositoryUriPatterns = this.getPatterns(exchangeV3RunIdRepositoryUriBasePath);
    }

    public boolean isExchangeRepo(String uri) {
        return this.evaluatePatterns(this.exchangeRepositoryUriPatterns, uri);
    }

    public String extractOrganizationIdFromExchangeRepositoryUri(String uri) {
        String organizationId = null;
        String sanitizedUri = this.sanitizeUri(uri);
        for (Pattern exchangeRepositoryUriPattern : this.exchangeRepositoryUriPatterns) {
            Matcher matcher = exchangeRepositoryUriPattern.matcher(sanitizedUri);
            if (!matcher.matches()) continue;
            organizationId = matcher.group(1);
            break;
        }
        return organizationId;
    }

    public String extractBaseAnypointUriFromMavenRepositoryUri(String uri) {
        if (this.customDomains.size() > 0) {
            return this.customDomains.get(0);
        }
        String baseUri = null;
        Matcher matcher = this.anypointPrefixUriPattern.matcher(uri);
        if (matcher.find()) {
            baseUri = "https://" + matcher.group(1);
        }
        return baseUri;
    }

    public boolean isMavenV3Uri(String uri) {
        return this.evaluatePatterns(this.exchangeV3RepositoryUriPatterns, uri);
    }

    public boolean isMavenV3UriWithoutOrganization(String uri) {
        return this.evaluatePatterns(this.exchangeV3RepositoryUriWithoutOrganizationPatterns, uri);
    }

    public boolean isMavenV3RunIdUri(String uri) {
        return this.evaluatePatterns(this.exchangeV3RunIdRepositoryUriPatterns, uri);
    }

    private List<Pattern> getPatterns(String pathname) {
        ArrayList domains = Lists.newArrayList(this.customDomains);
        domains.add(exchangeAnypointDomain);
        ArrayList patterns = Lists.newArrayList();
        for (String domain : domains) {
            patterns.add(Pattern.compile(String.format("^%s%s", domain, pathname)));
        }
        return patterns;
    }

    private boolean evaluatePatterns(List<Pattern> patterns, String uri) {
        String sanitizedUri = this.sanitizeUri(uri);
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(sanitizedUri).matches()) continue;
            return true;
        }
        return false;
    }

    private String sanitizeUri(String uri) {
        return Joiner.on((String)"/").skipNulls().join((Object[])uri.split("/"));
    }
}

