/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.mule.functional.api.component.LogChecker;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.mule.tck.processor.FlowAssert;
import org.mule.tck.processor.FlowAssertion;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class OnErrorCheckLogHandler
extends TemplateOnErrorHandler
implements MessagingExceptionHandlerAcceptor,
FlowAssertion {
    private final List<LogChecker> checkers = new ArrayList<LogChecker>();
    private StringBuilder errors;
    private boolean propagate = false;
    private boolean succeedIfNoLog = false;
    private boolean exceptionLogged = false;
    private boolean handledException = false;

    protected void doInitialise() throws InitialisationException {
        this.setMessageProcessors(Collections.singletonList(event -> event));
        super.doInitialise();
    }

    public void start() throws MuleException {
        super.start();
        this.errors = new StringBuilder();
        FlowAssert.addAssertion((String)this.getRootContainerLocation().toString(), (FlowAssertion)this);
        this.setHandleException(!this.propagate);
    }

    protected Publisher<CoreEvent> route(Publisher<CoreEvent> eventPublisher) {
        return super.route((Publisher)Flux.from(eventPublisher).doOnNext(e -> {
            this.handledException = true;
        }));
    }

    public TemplateOnErrorHandler duplicateFor(ComponentLocation buildFor) {
        OnErrorCheckLogHandler cpy = new OnErrorCheckLogHandler();
        cpy.setFlowLocation(buildFor);
        cpy.propagate = this.propagate;
        cpy.succeedIfNoLog = this.succeedIfNoLog;
        cpy.exceptionLogged = this.exceptionLogged;
        cpy.handledException = this.handledException;
        this.when.ifPresent(expr -> cpy.setWhen((String)expr));
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setExceptionListener(this.getExceptionListener());
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    protected boolean logException(Throwable t, CoreEvent event) {
        Pair resolvedException = this.getExceptionListener().resolveExceptionAndMessageToLog(t);
        for (LogChecker checker : this.checkers) {
            try {
                checker.check((String)resolvedException.getSecond());
            }
            catch (AssertionError e) {
                this.errors.append(((Throwable)((Object)e)).getMessage());
            }
        }
        if (super.logException(t, event)) {
            this.exceptionLogged = true;
            return true;
        }
        return false;
    }

    public void verify() {
        String errorMessage;
        if (!this.handledException) {
            Assert.fail((String)"Handler could not check any exception log because no exception was raised");
        }
        if (!StringUtils.isBlank((String)(errorMessage = this.errors.toString()))) {
            Assert.fail((String)errorMessage);
        }
        if (!this.exceptionLogged && !this.succeedIfNoLog) {
            Assert.fail((String)"Could not check exception because it was never logged");
        }
    }

    public boolean acceptsAll() {
        return true;
    }

    public void setCheckers(List<LogChecker> logCheckers) {
        this.checkers.addAll(logCheckers);
    }

    public List<LogChecker> getCheckers() {
        return this.checkers;
    }

    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public void setSucceedIfNoLog(boolean succeedIfNoLog) {
        this.succeedIfNoLog = succeedIfNoLog;
    }
}

