/*
 * Decompiled with CFR 0.152.
 */
package org.mule.functional.api.component;

import org.apache.commons.lang3.StringUtils;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;

public class QueueReaderMessageProcessor
implements Processor {
    private final String queueName;
    private final Long timeout;
    private final TestConnectorQueueHandler queueHandler;

    public QueueReaderMessageProcessor(Registry registry, String queueName, Long timeout) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)queueName) ? 1 : 0) != 0, (String)"Queue name cannot be empty");
        if (timeout != null) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout cannot be negative");
        }
        this.queueHandler = new TestConnectorQueueHandler(registry);
        this.queueName = queueName;
        this.timeout = timeout;
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.timeout == null) {
            return this.queueHandler.read(this.queueName);
        }
        return this.queueHandler.read(this.queueName, this.timeout);
    }
}

