/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transactional;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.tx.TransactionHandle;
import org.mule.test.transactional.TransactionalMetadataResolver;
import org.mule.test.transactional.connection.DummyXaResource;
import org.mule.test.transactional.connection.TestTransactionalConnection;
import org.mule.test.transactional.connection.TestXaTransactionalConnection;

@MetadataScope(outputResolver=TransactionalMetadataResolver.class)
public class TransactionalSource
extends Source<TestTransactionalConnection, Object> {
    private static final String IS_XA = "isXa";
    public static Boolean isSuccess;
    public static DummyXaResource xaResource;
    @Parameter
    TransactionType txType;
    @Connection
    private ConnectionProvider<TestTransactionalConnection> connectionProvider;
    private ExecutorService connectExecutor;

    public TransactionalSource() {
        isSuccess = null;
        xaResource = null;
    }

    public void onStart(SourceCallback<TestTransactionalConnection, Object> sourceCallback) {
        this.connectExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory(TransactionalSource.class.getName()));
        this.connectExecutor.execute(() -> {
            SourceCallbackContext ctx = sourceCallback.createContext();
            TransactionHandle txHandle = null;
            try {
                TestTransactionalConnection connection = (TestTransactionalConnection)this.connectionProvider.connect();
                boolean isXa = false;
                if (connection instanceof XATransactionalConnection) {
                    isXa = true;
                    xaResource = (DummyXaResource)((XATransactionalConnection)connection).getXAResource();
                }
                ctx.addVariable(IS_XA, (Object)isXa);
                txHandle = ctx.bindConnection((Object)connection);
                sourceCallback.handle(Result.builder().output((Object)connection).build(), ctx);
            }
            catch (ConnectionException e) {
                sourceCallback.onConnectionException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (txHandle != null) {
                        txHandle.commit();
                    }
                }
                catch (TransactionException e) {
                    try {
                        txHandle.rollback();
                    }
                    catch (TransactionException e1) {
                        RuntimeException rollbackException = new RuntimeException(e1);
                        rollbackException.addSuppressed(e);
                        throw rollbackException;
                    }
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void onStop() {
        this.connectExecutor.shutdownNow();
        this.connectExecutor = null;
    }

    @OnSuccess
    public void onSuccess(SourceCallbackContext ctx) throws TransactionException {
        ctx.getTransactionHandle().commit();
        isSuccess = true;
    }

    @OnError
    public void onError(SourceCallbackContext ctx) throws TransactionException {
        ctx.getTransactionHandle().rollback();
        isSuccess = false;
    }

    @OnTerminate
    public void onTerminate(SourceCallbackContext ctx) {
        Boolean isXa = (Boolean)ctx.getVariable(IS_XA).get();
        if (isXa.booleanValue()) {
            TestXaTransactionalConnection connection = (TestXaTransactionalConnection)ctx.getConnection();
            DummyXaResource dummyXaResource = (DummyXaResource)connection.getXAResource();
        }
    }
}

