/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.mule.tck.junit4.rule.FreePortFinder;
import org.mule.tck.junit4.rule.SystemProperty;

public class DynamicPort
extends SystemProperty {
    public static final String MIN_PORT_SYSTEM_PROPERTY = "mule.test.minPort";
    public static final String MAX_PORT_SYSTEM_PROPERTY = "mule.test.maxPort";
    private static final int DEFAULT_MIN_PORT = 10000;
    private static final int DEFAULT_MAX_PORT = 40000;
    protected static FreePortFinder freePortFinder;
    private int number;

    public DynamicPort(String name) {
        super(name);
    }

    @Override
    public String getValue() {
        return Integer.toString(this.getNumber());
    }

    @Override
    protected void doCleanUp() {
        freePortFinder.releasePort(this.number);
    }

    public int getNumber() {
        if (this.number == 0) {
            this.number = freePortFinder.find();
        }
        return this.number;
    }

    static {
        int minPort = 10000;
        int maxPort = 40000;
        String propertyValue = System.getProperty(MIN_PORT_SYSTEM_PROPERTY);
        if (propertyValue != null) {
            minPort = Integer.parseInt(propertyValue);
        }
        if ((propertyValue = System.getProperty(MAX_PORT_SYSTEM_PROPERTY)) != null) {
            maxPort = Integer.parseInt(propertyValue);
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException(String.format("Min port '%s' must be less than max port '%s'", minPort, maxPort));
        }
        freePortFinder = new FreePortFinder(minPort, maxPort);
    }
}

