/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config.builders;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerContainerPoolsConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;
import org.mule.runtime.core.internal.config.builders.SimpleRegistryBootstrap;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connection.DefaultConnectivityTesterFactory;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.dataweave.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.internal.management.stats.PayloadStatisticsCursorDecoratorFactory;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.TypeBasedTransformerResolver;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.serialization.JavaObjectSerializer;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DefaultTransformersRegistry;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.runtime.core.privileged.transformer.TransformersRegistry;

public class DefaultsConfigurationBuilder
extends AbstractConfigurationBuilder {
    protected void doConfigure(MuleContext muleContext) throws Exception {
        MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
        new SimpleRegistryBootstrap(ArtifactType.APP, muleContext).initialise();
        this.configureQueueManager(muleContext);
        registry.registerObject("_muleContext", (Object)muleContext);
        for (Map.Entry entry : ((CustomServiceRegistry)muleContext.getCustomizationService()).getCustomServices().entrySet()) {
            ((CustomService)entry.getValue()).getServiceImpl().ifPresent(s -> {
                try {
                    this.registerObject((String)entry.getKey(), s, muleContext);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
        }
        this.registerObject("_muleSecurityManager", new DefaultMuleSecurityManager(), muleContext);
        this.registerObject("_defaultInMemoryObjectStore", DefaultObjectStoreFactoryBean.createDefaultInMemoryObjectStore(), muleContext);
        this.registerObject("_defaultPersistentObjectStore", DefaultObjectStoreFactoryBean.createDefaultPersistentObjectStore(), muleContext);
        this.registerLocalObjectStoreManager(muleContext, registry);
        this.registerObject("_muleSchedulerPoolsConfig", SchedulerContainerPoolsConfig.getInstance(), muleContext);
        this.registerObject("_muleSchedulerBaseConfig", SchedulerConfig.config().withPrefix(muleContext.getConfiguration().getId()).withShutdownTimeout(() -> muleContext.getConfiguration().getShutdownTimeout(), TimeUnit.MILLISECONDS), muleContext);
        this.registerObject("_muleObjectStoreManager", new MuleObjectStoreManager(), muleContext);
        this.registerObject("_muleMessageProcessingManager", new MuleMessageProcessingManager(), muleContext);
        this.registerObject("_muleStreamCloserService", new DefaultStreamCloserService(), muleContext);
        this.registerObject("_muleLockProvider", new SingleServerLockProvider(), muleContext);
        this.registerObject("_muleLockFactory", new MuleLockFactory(), muleContext);
        this.registerObject("_muleProcessingTimeWatcher", new DefaultProcessingTimeWatcher(), muleContext);
        this.registerObject("_mulePayloadStatisticsCursorDecoratorFactory", new PayloadStatisticsCursorDecoratorFactory(), muleContext);
        DefaultTransformersRegistry transformersRegistry = new DefaultTransformersRegistry();
        this.registerObject("_muleTransfromersRegistry", transformersRegistry, muleContext);
        this.registerObject("_converterResolver", new DynamicDataTypeConversionResolver((TransformersRegistry)transformersRegistry), muleContext);
        this.registerObject("_muleTransformationService", new ExtendedTransformationService(muleContext), muleContext);
        this.registerObject("_muleTransfromerResolver", new TypeBasedTransformerResolver(), muleContext);
        this.registerObject("_muleDefaultObjectSerializer", new JavaObjectSerializer(), muleContext);
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerObject(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository, muleContext);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)contributedErrorTypeRepository));
        this.registerObject(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator, muleContext);
        try {
            Class<?> mvelLangCls = Class.forName("org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage");
            mvelLangCls.getConstructor(MuleContext.class).newInstance(muleContext);
            this.registerObject("_muleExpressionLanguage", mvelLangCls.getConstructor(MuleContext.class).newInstance(muleContext), muleContext);
            this.registerObject("_compatibilityPluginInstalled", true, muleContext);
        }
        catch (ClassNotFoundException mvelLangCls) {
            // empty catch block
        }
        this.registerObject("_muleStreamingGhostBuster", new StreamingGhostBuster(), muleContext);
        this.registerObject("_muleStreamingManager", new DefaultStreamingManager(), muleContext);
        DefaultExpressionManager expressionManager = new DefaultExpressionManager();
        DefaultExpressionLanguageFactoryService service = (DefaultExpressionLanguageFactoryService)registry.lookupObject(DefaultExpressionLanguageFactoryService.class);
        expressionManager.setExpressionLanguage((ExtendedExpressionLanguageAdaptor)new DataWeaveExpressionLanguageAdaptor(muleContext, null, service, null));
        this.registerObject("_muleExpressionManager", expressionManager, muleContext);
        this.registerObject("_muleTimeSupplier", new LocalTimeSupplier(), muleContext);
        this.registerObject("_muleConnectionManager", new DefaultConnectionManager(muleContext), muleContext);
        this.registerObject("_muleMetadataService", new MuleMetadataService(), muleContext);
        this.registerObject("_muleValueProviderService", new MuleValueProviderService(), muleContext);
        this.registerObject("_muleInterceptorManager", new DefaultProcessorInterceptorManager(), muleContext);
        this.registerObject("_muleNotificationDispatcher", new DefaultNotificationDispatcher(), muleContext);
        this.registerObject("_muleNotificationListenerRegistry", new DefaultNotificationListenerRegistry(), muleContext);
        this.registerObject("_muleEventContextService", new DefaultEventContextService(), muleContext);
        this.registerObject("_muleTransactionFactoryLocator", new TransactionFactoryLocator(), muleContext);
        this.registerObject("_muleClusterService", new DefaultClusterService(), muleContext);
        this.registerObject("_muleConnectivityTesterFactory", new DefaultConnectivityTesterFactory(), muleContext);
        if (((MuleContextWithRegistry)muleContext).getRegistry().lookupObject("_muleProfilingService") == null) {
            this.registerObject("_muleProfilingService", new DefaultProfilingService(), muleContext);
        }
        this.registerObject("_muleComponentInitialStateManager", new ComponentInitialStateManager(){

            public boolean mustStartMessageSource(Component component) {
                return true;
            }
        }, muleContext);
        this.registerObject("_muleResourceLocator", new DefaultResourceLocator(), muleContext);
    }

    protected void registerObject(String serviceId, Object serviceImpl, MuleContext muleContext) throws RegistrationException {
        if (serviceImpl instanceof MuleContextAware) {
            ((MuleContextAware)serviceImpl).setMuleContext(muleContext);
        }
        ((MuleContextWithRegistry)muleContext).getRegistry().registerObject(serviceId, serviceImpl);
    }

    private void registerLocalObjectStoreManager(MuleContext muleContext, MuleRegistry registry) throws RegistrationException {
        MuleObjectStoreManager osm = new MuleObjectStoreManager();
        osm.setBasePersistentStoreKey("_defaultPersistentObjectStore");
        osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
        osm.setMuleContext(muleContext);
        registry.registerObject("_muleObjectStoreManager", (Object)osm);
    }

    protected void configureQueueManager(MuleContext muleContext) throws RegistrationException {
        TransactionalQueueManager queueManager = new TransactionalQueueManager();
        this.registerObject("_muleQueueManager", queueManager, muleContext);
        this.registerObject("_localQueueManager", queueManager, muleContext);
    }
}

