/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.Callable;

public class ClassUtils {
    public static void withContextClassLoader(ClassLoader classLoader, Runnable runnable) {
        ClassUtils.withContextClassLoader(classLoader, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    public static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader) {
            thread.setContextClassLoader(newClassLoader);
        }
    }

    public static Class<?>[] findImplementedInterfaces(Class<?> aClass) {
        Objects.requireNonNull(aClass, "Class to analyze cannot be null");
        LinkedList foundInterfaces = new LinkedList();
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces = currentClass.getInterfaces();
            Collections.addAll(foundInterfaces, interfaces);
        }
        return foundInterfaces.toArray(new Class[0]);
    }
}

