/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.mule.test.runner.RunnerConfigSystemProperty;
import org.mule.test.runner.utils.AnnotationUtils;

public class RunnerConfiguration {
    private static final String PROVIDED_EXCLUSIONS = "providedExclusions";
    private static final String TEST_EXCLUSIONS = "testExclusions";
    private static final String TEST_INCLUSIONS = "testInclusions";
    private static final String EXPORT_PLUGIN_CLASSES = "exportPluginClasses";
    private static final String SHARED_RUNTIME_LIBS = "applicationSharedRuntimeLibs";
    private static final String APPLICATION_RUNTIME_LIBS = "applicationRuntimeLibs";
    private static final String TEST_RUNNER_EXPORTED_RUNTIME_LIBS = "testRunnerExportedRuntimeLibs";
    private static final String EXTRA_PRIVILEGED_ARTIFACTS = "extraPrivilegedArtifacts";
    public static final String TEST_RUNNER_ARTIFACT_ID = "org.mule.tests.plugin:mule-tests-runner-plugin";
    public static final String TEST_UNIT_ARTIFACT_ID = "org.mule.tests:mule-tests-unit";
    private Set<String> providedExclusions;
    private Set<String> testExclusions;
    private Set<String> testInclusions;
    private Set<Class> exportPluginClasses;
    private Set<String> sharedApplicationRuntimeLibs;
    private Set<String> applicationRuntimeLibs;
    private Set<String> testRunnerExportedRuntimeLibs;
    private Set<String> extraPrivilegedArtifacts;
    private Map<String, String> systemProperties;
    private final String loadedFromTestClass;

    private RunnerConfiguration(Class loadedFromTestClass) {
        this.loadedFromTestClass = loadedFromTestClass.getName();
    }

    public Set<Class> getExportPluginClasses() {
        return this.exportPluginClasses;
    }

    public Set<String> getProvidedExclusions() {
        return this.providedExclusions;
    }

    public Set<String> getSharedApplicationRuntimeLibs() {
        return this.sharedApplicationRuntimeLibs;
    }

    public Set<String> getApplicationRuntimeLibs() {
        return this.applicationRuntimeLibs;
    }

    public Set<String> getTestRunnerExportedRuntimeLibs() {
        return this.testRunnerExportedRuntimeLibs;
    }

    public Set<String> getTestExclusions() {
        return this.testExclusions;
    }

    public Set<String> getTestInclusions() {
        return this.testInclusions;
    }

    public Set<String> getExtraPrivilegedArtifacts() {
        return this.extraPrivilegedArtifacts;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public static RunnerConfiguration readConfiguration(Class testClass) {
        RunnerConfiguration runnerConfiguration = new RunnerConfiguration(testClass);
        runnerConfiguration.providedExclusions = new HashSet<String>(RunnerConfiguration.readAttributeFromHierarchy(PROVIDED_EXCLUSIONS, testClass));
        runnerConfiguration.testExclusions = new HashSet<String>(RunnerConfiguration.readAttributeFromHierarchy(TEST_EXCLUSIONS, testClass));
        runnerConfiguration.testInclusions = new HashSet<String>(RunnerConfiguration.readAttributeFromHierarchy(TEST_INCLUSIONS, testClass));
        Class configuredClass = AnnotationUtils.findConfiguredClass(testClass);
        runnerConfiguration.exportPluginClasses = new HashSet<Class>(RunnerConfiguration.readAttributeFromClass(EXPORT_PLUGIN_CLASSES, configuredClass));
        runnerConfiguration.sharedApplicationRuntimeLibs = new HashSet<String>(RunnerConfiguration.readAttributeFromClass(SHARED_RUNTIME_LIBS, configuredClass));
        runnerConfiguration.applicationRuntimeLibs = new HashSet<String>(RunnerConfiguration.readAttributeFromClass(APPLICATION_RUNTIME_LIBS, configuredClass));
        runnerConfiguration.extraPrivilegedArtifacts = new HashSet<String>(RunnerConfiguration.readAttributeFromClass(EXTRA_PRIVILEGED_ARTIFACTS, configuredClass));
        runnerConfiguration.extraPrivilegedArtifacts.add(TEST_RUNNER_ARTIFACT_ID);
        runnerConfiguration.testRunnerExportedRuntimeLibs = new HashSet<String>(RunnerConfiguration.readAttributeFromClass(TEST_RUNNER_EXPORTED_RUNTIME_LIBS, configuredClass));
        runnerConfiguration.testRunnerExportedRuntimeLibs.add(TEST_UNIT_ARTIFACT_ID);
        List systemProperties = RunnerConfiguration.readAttributeFromHierarchy("systemProperties", testClass);
        runnerConfiguration.systemProperties = systemProperties.stream().collect(Collectors.toMap(RunnerConfigSystemProperty::key, RunnerConfigSystemProperty::value));
        return runnerConfiguration;
    }

    private static <E> List<E> readAttributeFromHierarchy(String name, Class<?> klass) {
        List valuesList = AnnotationUtils.getAnnotationAttributeFromHierarchy(klass, ArtifactClassLoaderRunnerConfig.class, name);
        return valuesList.stream().flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    private static <E> List<E> readAttributeFromClass(String name, Class<?> klass) {
        List<Object[]> valuesList = Collections.singletonList((Object[])AnnotationUtils.getAnnotationAttributeFrom(klass, ArtifactClassLoaderRunnerConfig.class, name));
        return valuesList.stream().flatMap(Arrays::stream).distinct().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunnerConfiguration that = (RunnerConfiguration)o;
        if (!this.providedExclusions.equals(that.providedExclusions)) {
            return false;
        }
        if (!this.testExclusions.equals(that.testExclusions)) {
            return false;
        }
        if (!this.testInclusions.equals(that.testInclusions)) {
            return false;
        }
        if (!this.exportPluginClasses.equals(that.exportPluginClasses)) {
            return false;
        }
        if (!this.applicationRuntimeLibs.equals(that.applicationRuntimeLibs)) {
            return false;
        }
        if (!this.testRunnerExportedRuntimeLibs.equals(that.testRunnerExportedRuntimeLibs)) {
            return false;
        }
        return this.sharedApplicationRuntimeLibs.equals(that.sharedApplicationRuntimeLibs);
    }

    public int hashCode() {
        int result = this.providedExclusions.hashCode();
        result = 31 * result + this.testExclusions.hashCode();
        result = 31 * result + this.testInclusions.hashCode();
        result = 31 * result + this.exportPluginClasses.hashCode();
        result = 31 * result + this.sharedApplicationRuntimeLibs.hashCode();
        result = 31 * result + this.applicationRuntimeLibs.hashCode();
        result = 31 * result + this.testRunnerExportedRuntimeLibs.hashCode();
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

