/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.base.Joiner;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.MuleMavenRepositoryState;
import org.mule.maven.client.internal.MuleMavenRepositoryStateFactory;
import org.mule.maven.client.internal.MuleMavenResolutionContext;
import org.mule.test.runner.classification.PatternExclusionsDependencyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyResolver
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MuleMavenResolutionContext resolutionContext;
    private final MuleMavenRepositoryState repositoryState;
    private final MuleMavenRepositoryStateFactory repositoryStateFactory;
    private boolean closed = false;

    public DependencyResolver(MavenConfiguration mavenConfiguration, Optional<WorkspaceReader> workspaceReader) {
        Objects.requireNonNull(mavenConfiguration, "mavenConfiguration cannot be null");
        this.resolutionContext = new MuleMavenResolutionContext(mavenConfiguration);
        this.repositoryStateFactory = new MuleMavenRepositoryStateFactory();
        this.repositoryState = this.repositoryStateFactory.createMavenRepositoryState(this.resolutionContext.getLocalRepositoryLocation(), workspaceReader, this.resolutionContext.getAuthenticatorSelector(), this.resolutionContext.getProxySelector(), this.resolutionContext.getMirrorSelector(), mavenConfiguration.getForcePolicyUpdateNever(), mavenConfiguration.getForcePolicyUpdateAlways(), mavenConfiguration.getOfflineMode(), mavenConfiguration.getIgnoreArtifactDescriptorRepositories(), Optional.empty(), session -> {}, mavenConfiguration.getGlobalChecksumPolicy());
        if (this.logger.isDebugEnabled()) {
            this.resolutionContext.getAuthenticatorSelector().ifPresent(selector -> this.logger.debug("Using authenticator selector: " + ReflectionToStringBuilder.toString((Object)selector)));
        }
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact) throws ArtifactDescriptorException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.resolveRepositories(), null);
        return this.repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactDescriptorException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.resolveRepositories(remoteRepositories), null);
        return this.repositoryState.getSystem().readArtifactDescriptor((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactResult resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        ArtifactRequest request = new ArtifactRequest(artifact, this.resolveRepositories(), null);
        return this.repositoryState.getSystem().resolveArtifact((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public ArtifactResult resolveArtifact(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        ArtifactRequest request = new ArtifactRequest(artifact, this.resolveRepositories(remoteRepositories), null);
        return this.repositoryState.getSystem().resolveArtifact((RepositorySystemSession)this.repositoryState.getSession(), request);
    }

    public List<Dependency> getDirectDependencies(Artifact artifact) throws ArtifactDescriptorException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        return this.readArtifactDescriptor(artifact).getDependencies();
    }

    public List<Dependency> getDirectDependencies(Artifact artifact, List<RemoteRepository> remoteRepositories) throws ArtifactDescriptorException {
        Objects.requireNonNull(artifact, "artifact cannot be null");
        return this.readArtifactDescriptor(artifact, remoteRepositories).getDependencies();
    }

    public ContainerDependencies resolveContainerDependencies(Dependency root, List<Dependency> directDependencies, List<Dependency> managedDependencies, List<String> excludedFilterPattern, List<RemoteRepository> remoteRepositories) throws DependencyCollectionException, DependencyResolutionException {
        DependencyNode muleApisNode = this.getMuleApisNode(Collections.unmodifiableList(excludedFilterPattern));
        PatternExclusionsDependencyFilter dependencyFilter = new PatternExclusionsDependencyFilter(excludedFilterPattern);
        DependencyNode muleLibsNode = this.resolveDependencyNode(root, directDependencies, managedDependencies, dependencyFilter, remoteRepositories);
        return this.getContainerDependencies(muleApisNode, muleLibsNode);
    }

    private DependencyNode getMuleApisNode(List<String> excludedFilterPattern) throws DependencyCollectionException, DependencyResolutionException {
        try {
            PatternExclusionsDependencyFilter dependencyFilter = new PatternExclusionsDependencyFilter(excludedFilterPattern);
            String version = this.getImplementationVersion();
            ArtifactDescriptorResult pom = this.readArtifactDescriptor((Artifact)new DefaultArtifact("com.mulesoft.mule.distributions", "mule-runtime-apis-split-loader-bom", "pom", version));
            return this.resolveDependencyNode(null, pom.getDependencies(), pom.getManagedDependencies(), dependencyFilter, pom.getRepositories());
        }
        catch (ArtifactDescriptorException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getImplementationVersion() {
        return this.getClass().getPackage().getImplementationVersion();
    }

    public List<File> resolveDependencies(Dependency root, List<Dependency> directDependencies, List<Dependency> managedDependencies, DependencyFilter dependencyFilter, List<RemoteRepository> remoteRepositories) throws DependencyCollectionException, DependencyResolutionException {
        DependencyNode node = this.resolveDependencyNode(root, directDependencies, managedDependencies, dependencyFilter, remoteRepositories);
        return this.getFiles(node);
    }

    private DependencyNode resolveDependencyNode(Dependency root, List<Dependency> directDependencies, List<Dependency> managedDependencies, DependencyFilter dependencyFilter, List<RemoteRepository> remoteRepositories) throws DependencyCollectionException, DependencyResolutionException {
        DependencyNode node;
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(root);
        collectRequest.setDependencies(directDependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(this.resolveRepositories(remoteRepositories));
        try {
            this.logger.debug("Collecting dependencies for '{}'", (Object)this.printCollectRequest(collectRequest));
            node = this.repositoryState.getSystem().collectDependencies((RepositorySystemSession)this.repositoryState.getSession(), collectRequest).getRoot();
            this.logDependencyGraph(node, collectRequest);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyRequest.setCollectRequest(collectRequest);
            dependencyRequest.setFilter((node1, parents) -> !node1.getData().containsKey("aether.conflictResolver.verbose") && (dependencyFilter == null || dependencyFilter.accept(node1, parents)));
            node = this.repositoryState.getSystem().resolveDependencies((RepositorySystemSession)this.repositoryState.getSession(), dependencyRequest).getRoot();
        }
        catch (DependencyResolutionException e) {
            this.logger.warn("Dependencies couldn't be resolved for request '{}', {}", (Object)collectRequest, (Object)e.getMessage());
            DependencyNode node2 = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node2, e);
            throw e;
        }
        return node;
    }

    private String printCollectRequest(CollectRequest collectRequest) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator iterator = collectRequest.getRepositories().iterator();
        while (iterator.hasNext()) {
            RemoteRepository remoteRepository = (RemoteRepository)iterator.next();
            stringBuilder.append(remoteRepository);
            stringBuilder.append("->authentication[");
            if (remoteRepository.getAuthentication() != null) {
                stringBuilder.append(remoteRepository.getAuthentication());
            }
            stringBuilder.append("]");
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return collectRequest.getRoot() + " -> " + collectRequest.getDependencies() + " < " + stringBuilder.toString();
    }

    private List<RemoteRepository> resolveRepositories() {
        return this.resolveRepositories(Collections.emptyList());
    }

    private List<RemoteRepository> resolveRepositories(List<RemoteRepository> remoteRepositories) {
        return this.repositoryState.getSystem().newResolutionRepositories((RepositorySystemSession)this.repositoryState.getSession(), Stream.of(remoteRepositories, this.resolutionContext.getRemoteRepositories()).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private void logDependencyGraph(DependencyNode node, Object request) {
        if (this.logger.isTraceEnabled()) {
            PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(null, false);
            node.accept((DependencyVisitor)visitor);
            this.logger.trace("******* Dependency Graph calculated for {} with request: '{}' *******", (Object)request.getClass().getSimpleName(), request);
            visitor.getPaths().stream().forEach(pathList -> this.logger.trace(Joiner.on((String)" -> ").join((Iterable)pathList.stream().filter(path -> path != null).collect(Collectors.toList()))));
            this.logger.trace("******* End of dependency Graph *******");
        }
    }

    private List<File> getFiles(DependencyNode node) {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nlg);
        return nlg.getFiles().stream().map(File::getAbsoluteFile).distinct().collect(Collectors.toList());
    }

    private ContainerDependencies getContainerDependencies(DependencyNode muleApisNode, DependencyNode muleLibsNode) {
        LinkedHashSet<URL> muleApisDependencyUrls = new LinkedHashSet<URL>();
        LinkedHashSet<URL> muleApisOptDependencyUrls = new LinkedHashSet<URL>();
        LinkedHashSet<URL> muleDependencyUrls = new LinkedHashSet<URL>();
        LinkedHashSet<URL> optDependencyUrls = new LinkedHashSet<URL>();
        this.splitMuleAndOpt(muleApisNode, muleApisDependencyUrls, muleApisOptDependencyUrls);
        this.splitMuleAndOpt(muleLibsNode, muleDependencyUrls, optDependencyUrls);
        optDependencyUrls.removeAll(muleApisOptDependencyUrls);
        muleDependencyUrls.removeAll(muleApisDependencyUrls);
        List<URL> log4jUrls = optDependencyUrls.stream().filter(url -> url.toString().contains("log4j") || url.toString().contains("lmax")).collect(Collectors.toList());
        muleApisOptDependencyUrls.addAll(log4jUrls);
        log4jUrls.forEach(optDependencyUrls::remove);
        return new ContainerDependencies(new ArrayList<URL>(muleApisDependencyUrls), new ArrayList<URL>(muleApisOptDependencyUrls), new ArrayList<URL>(optDependencyUrls), new ArrayList<URL>(muleDependencyUrls));
    }

    private void splitMuleAndOpt(DependencyNode node, Set<URL> muleDependencyUrls, Set<URL> optDependencyUrls) {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nlg);
        nlg.getNodes().stream().forEach(depNode -> {
            Artifact artifact = depNode.getArtifact();
            if (artifact.getFile() == null) {
                return;
            }
            File absoluteFile = artifact.getFile().getAbsoluteFile();
            if (this.isMuleContainerGroupId(artifact.getGroupId())) {
                muleDependencyUrls.add(this.toUrl(absoluteFile));
            } else {
                optDependencyUrls.add(this.toUrl(absoluteFile));
            }
        });
    }

    private URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Couldn't get URL", e);
        }
    }

    private boolean isMuleContainerGroupId(String groupId) {
        return groupId.equals("org.mule.runtime") || groupId.equals("org.mule.runtime.boot") || groupId.equals("org.mule.sdk") || groupId.equals("org.mule.weave") || groupId.equals("org.mule.commons") || groupId.equals("com.mulesoft.mule.runtime") || groupId.equals("com.mulesoft.mule.runtime.boot") || groupId.equals("com.mulesoft.mule.runtime.modules") || groupId.equals("com.mulesoft.anypoint") || groupId.equals("com.mulesoft.connectivity");
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty()) {
                this.logger.warn("Dependency path to not resolved artifacts -> {}", (Object)unresolvedArtifactPath.toString());
            }
        });
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.repositoryStateFactory.close();
            this.closed = true;
        }
    }

    public static class ContainerDependencies {
        private final List<URL> muleApisDependencyUrls;
        private final List<URL> muleApisOptDependencyUrls;
        private final List<URL> muleDependencyUrls;
        private final List<URL> optDependencyUrls;

        ContainerDependencies(List<URL> muleApisDependencyUrls, List<URL> muleApisOptDependencyUrls, List<URL> optDependencyUrls, List<URL> muleDependencyUrls) {
            this.muleApisDependencyUrls = Collections.unmodifiableList(muleApisDependencyUrls);
            this.muleApisOptDependencyUrls = Collections.unmodifiableList(muleApisOptDependencyUrls);
            this.muleDependencyUrls = Collections.unmodifiableList(muleDependencyUrls);
            this.optDependencyUrls = Collections.unmodifiableList(optDependencyUrls);
        }

        public List<URL> getMuleApisDependencyUrls() {
            return this.muleApisDependencyUrls;
        }

        public List<URL> getMuleApisOptDependencyUrls() {
            return this.muleApisOptDependencyUrls;
        }

        public List<URL> getOptDependencyUrls() {
            return this.optDependencyUrls;
        }

        public List<URL> getMuleDependencyUrls() {
            return this.muleDependencyUrls;
        }
    }
}

