/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader.container;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderCreatorUtils;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.test.runner.classloader.container.TestContainerModuleDiscoverer;

public class TestPreFilteredContainerClassLoaderCreator
implements PreFilteredContainerClassLoaderCreator {
    private final Set<String> extraBootPackages;
    private final URL[] muleUrls;
    private final URL[] optUrls;
    private final URLClassLoader classLoader;
    private final DefaultModuleRepository testContainerModuleRepository;
    private ArtifactClassLoader containerClassLoader;

    public TestPreFilteredContainerClassLoaderCreator(List<String> extraBootPackages, URL[] muleUrls, URL[] optUrls) {
        this.extraBootPackages = ImmutableSet.builder().addAll((Iterable)BOOT_PACKAGES).addAll(extraBootPackages).addAll((Iterable)((MuleModule)new JreModuleDiscoverer().discover().get(0)).getExportedPackages()).build();
        this.muleUrls = muleUrls;
        this.optUrls = optUrls;
        this.classLoader = new URLClassLoader(muleUrls, null);
        this.testContainerModuleRepository = new DefaultModuleRepository((ModuleDiscoverer)new TestContainerModuleDiscoverer(this.classLoader));
    }

    public List<MuleModule> getMuleModules() {
        return (List)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> ((DefaultModuleRepository)this.testContainerModuleRepository).getModules());
    }

    public Set<String> getBootPackages() {
        return this.extraBootPackages;
    }

    public ArtifactClassLoader getPreFilteredContainerClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader) {
        URLClassLoader containerOptClassLoader = new URLClassLoader(this.optUrls, parentClassLoader);
        this.containerClassLoader = new MuleArtifactClassLoader(artifactDescriptor.getName(), artifactDescriptor, this.muleUrls, (ClassLoader)containerOptClassLoader, (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), this.getBootPackages()));
        return this.containerClassLoader;
    }

    public ArtifactClassLoader getBuiltPreFilteredContainerClassLoader() {
        return this.containerClassLoader;
    }

    public ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy(ClassLoader parentClassLoader) {
        return ContainerClassLoaderCreatorUtils.getLookupPolicy((ClassLoader)parentClassLoader, (List)this.testContainerModuleRepository.getModules(), this.getBootPackages());
    }

    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

