/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoader;
import org.mule.runtime.deployment.model.internal.nativelib.DefaultNativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.internal.util.FileJarExplorer;
import org.mule.runtime.module.artifact.internal.util.JarInfo;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.classloader.PluginLookPolicyFactory;
import org.mule.test.runner.classloader.TestArtifactClassLoaderFilter;
import org.mule.test.runner.classloader.TestContainerClassLoaderFactory;
import org.mule.test.runner.classloader.TestContainerModuleDiscoverer;
import org.mule.test.runner.classloader.TestModuleDiscoverer;
import org.mule.test.runner.classloader.TestRegionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolatedClassLoaderFactory.class);
    private static final String APP_NAME = "app";
    private final ClassLoaderFilterFactory classLoaderFilterFactory = new ArtifactClassLoaderFilterFactory();
    private final PluginLookPolicyFactory pluginLookupPolicyGenerator = new PluginLookPolicyFactory();

    public ArtifactClassLoaderHolder createArtifactClassLoader(List<String> extraBootPackages, Set<String> extraPrivilegedArtifacts, ArtifactsUrlClassification artifactsUrlClassification) {
        HashMap<String, LookupStrategy> appExportedLookupStrategies = new HashMap<String, LookupStrategy>();
        JarInfo testJarInfo = this.getAppSharedPackages(artifactsUrlClassification.getApplicationSharedLibUrls());
        testJarInfo.getPackages().stream().forEach(p -> appExportedLookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        ArrayList<ArtifactClassLoader> filteredPluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoader> pluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters = new ArrayList<ArtifactClassLoaderFilter>();
        DefaultModuleRepository moduleRepository = new DefaultModuleRepository((ModuleDiscoverer)new TestModuleDiscoverer(extraPrivilegedArtifacts, (ModuleDiscoverer)new TestContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader())));
        try (TestContainerClassLoaderFactory testContainerClassLoaderFactory = new TestContainerClassLoaderFactory(extraBootPackages, artifactsUrlClassification.getContainerUrls().toArray(new URL[0]), (ModuleRepository)moduleRepository);){
            HashMap pluginsLookupStrategies = new HashMap();
            for (PluginUrlClassification pluginUrlClassification : artifactsUrlClassification.getPluginUrlClassifications()) {
                pluginUrlClassification.getExportedPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
            }
            ArtifactClassLoader containerClassLoader = this.createContainerArtifactClassLoader(testContainerClassLoaderFactory, artifactsUrlClassification);
            ClassLoaderLookupPolicy childClassLoaderLookupPolicy = testContainerClassLoaderFactory.getContainerClassLoaderLookupPolicy(containerClassLoader.getClassLoader());
            ClassLoaderLookupPolicy appLookupPolicy = childClassLoaderLookupPolicy.extend(pluginsLookupStrategies);
            List<ArtifactClassLoader> serviceArtifactClassLoaders = this.createServiceClassLoaders(containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy, artifactsUrlClassification);
            TestRegionClassLoader regionClassLoader = new TestRegionClassLoader(containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy);
            if (!artifactsUrlClassification.getPluginUrlClassifications().isEmpty()) {
                for (PluginUrlClassification pluginUrlClassification : artifactsUrlClassification.getPluginUrlClassifications()) {
                    this.logClassLoaderUrls("PLUGIN (" + pluginUrlClassification.getName() + ")", pluginUrlClassification.getUrls());
                    String artifactId = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)regionClassLoader.getArtifactId(), (String)pluginUrlClassification.getName());
                    ClassLoaderLookupPolicy pluginLookupPolicy = this.extendLookupPolicyForPrivilegedAccess(childClassLoaderLookupPolicy, (ModuleRepository)moduleRepository, testContainerClassLoaderFactory, pluginUrlClassification);
                    pluginLookupPolicy = pluginLookupPolicy.extend(appExportedLookupStrategies);
                    MuleArtifactClassLoader pluginCL = new MuleArtifactClassLoader(artifactId, new ArtifactDescriptor(pluginUrlClassification.getName()), pluginUrlClassification.getUrls().toArray(new URL[0]), (ClassLoader)((Object)regionClassLoader), this.pluginLookupPolicyGenerator.createLookupPolicy(pluginUrlClassification, artifactsUrlClassification.getPluginUrlClassifications(), pluginLookupPolicy, pluginsArtifactClassLoaders));
                    pluginsArtifactClassLoaders.add((ArtifactClassLoader)pluginCL);
                    ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(pluginUrlClassification, testJarInfo.getPackages(), childClassLoaderLookupPolicy);
                    pluginArtifactClassLoaderFilters.add(filter);
                    filteredPluginsArtifactClassLoaders.add((ArtifactClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)pluginCL, (ClassLoaderFilter)filter, Collections.emptyList()));
                }
                this.createTestRunnerPlugin(artifactsUrlClassification, appExportedLookupStrategies, childClassLoaderLookupPolicy, regionClassLoader, filteredPluginsArtifactClassLoaders, pluginsArtifactClassLoaders, pluginArtifactClassLoaderFilters, moduleRepository, testContainerClassLoaderFactory, testJarInfo.getPackages());
            }
            ArtifactClassLoader artifactClassLoader = this.createApplicationArtifactClassLoader((ClassLoader)((Object)regionClassLoader), appLookupPolicy, artifactsUrlClassification, pluginsArtifactClassLoaders);
            regionClassLoader.addClassLoader(artifactClassLoader, (ArtifactClassLoaderFilter)new DefaultArtifactClassLoaderFilter(testJarInfo.getPackages(), testJarInfo.getResources()));
            for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
                ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
                regionClassLoader.addClassLoader((ArtifactClassLoader)filteredPluginsArtifactClassLoaders.get(i), classLoaderFilter);
            }
            ArtifactClassLoaderHolder artifactClassLoaderHolder = new ArtifactClassLoaderHolder(containerClassLoader, serviceArtifactClassLoaders, pluginsArtifactClassLoaders, artifactClassLoader);
            return artifactClassLoaderHolder;
        }
    }

    private JarInfo getAppSharedPackages(List<URL> pluginSharedLibUrls) {
        ArrayList libraries = Lists.newArrayList();
        libraries.addAll(pluginSharedLibUrls);
        return this.getLibraryPackages(libraries);
    }

    private JarInfo getLibraryPackages(List<URL> libraries) {
        TreeSet packages = new TreeSet();
        TreeSet resources = new TreeSet();
        FileJarExplorer jarExplorer = new FileJarExplorer(false);
        for (URL library : libraries) {
            try {
                JarInfo jarInfo = jarExplorer.explore(library.toURI());
                packages.addAll(jarInfo.getPackages());
                resources.addAll(jarInfo.getResources());
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return new JarInfo(packages, resources, Collections.emptyList());
    }

    private void createTestRunnerPlugin(ArtifactsUrlClassification artifactsUrlClassification, Map<String, LookupStrategy> appExportedLookupStrategies, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, RegionClassLoader regionClassLoader, List<ArtifactClassLoader> filteredPluginsArtifactClassLoaders, List<ArtifactClassLoader> pluginsArtifactClassLoaders, List<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters, DefaultModuleRepository moduleRepository, TestContainerClassLoaderFactory testContainerClassLoaderFactory, Set<String> parentExportedPackages) {
        JarInfo testRunnerJarInfo = this.getTestRunnerJarInfo(artifactsUrlClassification);
        String testRunnerArtifactId = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId((String)regionClassLoader.getArtifactId(), (String)"test-runner");
        List<String> pluginDependencies = artifactsUrlClassification.getPluginUrlClassifications().stream().map(p -> p.getName()).collect(Collectors.toList());
        PluginUrlClassification testRunnerPluginClassification = new PluginUrlClassification("org.mule.tests.plugin:mule-tests-runner-plugin:", artifactsUrlClassification.getTestRunnerLibUrls(), Collections.emptyList(), pluginDependencies, testRunnerJarInfo.getPackages(), testRunnerJarInfo.getResources(), Collections.emptySet(), Collections.emptySet());
        ClassLoaderLookupPolicy pluginLookupPolicy = this.extendLookupPolicyForPrivilegedAccess(childClassLoaderLookupPolicy, (ModuleRepository)moduleRepository, testContainerClassLoaderFactory, testRunnerPluginClassification);
        pluginLookupPolicy = pluginLookupPolicy.extend(appExportedLookupStrategies);
        MuleArtifactClassLoader pluginCL = new MuleArtifactClassLoader(testRunnerArtifactId, new ArtifactDescriptor(testRunnerPluginClassification.getName()), testRunnerPluginClassification.getUrls().toArray(new URL[0]), (ClassLoader)regionClassLoader, this.pluginLookupPolicyGenerator.createLookupPolicy(testRunnerPluginClassification, artifactsUrlClassification.getPluginUrlClassifications(), pluginLookupPolicy, pluginsArtifactClassLoaders));
        pluginsArtifactClassLoaders.add((ArtifactClassLoader)pluginCL);
        ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(testRunnerPluginClassification, parentExportedPackages, childClassLoaderLookupPolicy);
        pluginArtifactClassLoaderFilters.add(filter);
        filteredPluginsArtifactClassLoaders.add((ArtifactClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)pluginCL, (ClassLoaderFilter)filter, Collections.emptyList()));
        this.logClassLoaderUrls("PLUGIN (" + testRunnerPluginClassification.getName() + ")", testRunnerPluginClassification.getUrls());
    }

    private JarInfo getTestRunnerJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        JarInfo testJarInfo = this.getTestJarInfo(artifactsUrlClassification);
        Set exportedPackages = testJarInfo.getPackages();
        Set exportedResources = testJarInfo.getResources();
        artifactsUrlClassification.getTestRunnerExportedLibUrls().forEach(url -> {
            JarInfo jarInfo = this.getTestCodePackages((URL)url);
            exportedPackages.addAll(jarInfo.getPackages());
            exportedResources.addAll(jarInfo.getResources());
        });
        return new JarInfo(exportedPackages, exportedResources, Collections.emptyList());
    }

    private ClassLoaderLookupPolicy extendLookupPolicyForPrivilegedAccess(ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ModuleRepository moduleRepository, TestContainerClassLoaderFactory testContainerClassLoaderFactory, PluginUrlClassification pluginUrlClassification) {
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(testContainerClassLoaderFactory.getContainerClassLoader().getClassLoader());
        HashMap<String, ContainerOnlyLookupStrategy> privilegedLookupStrategies = new HashMap<String, ContainerOnlyLookupStrategy>();
        for (MuleModule module : moduleRepository.getModules()) {
            if (!this.hasPrivilegedApiAccess(pluginUrlClassification, module)) continue;
            for (String packageName : module.getPrivilegedExportedPackages()) {
                privilegedLookupStrategies.put(packageName, containerOnlyLookupStrategy);
            }
        }
        if (privilegedLookupStrategies.isEmpty()) {
            return childClassLoaderLookupPolicy;
        }
        return childClassLoaderLookupPolicy.extend(privilegedLookupStrategies);
    }

    private boolean hasPrivilegedApiAccess(PluginUrlClassification pluginUrlClassification, MuleModule module) {
        return module.getPrivilegedArtifacts().stream().filter(artifact -> pluginUrlClassification.getName().startsWith(artifact + ":")).findFirst().isPresent();
    }

    protected List<ArtifactClassLoader> createServiceClassLoaders(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification) {
        ArrayList servicesArtifactClassLoaders = Lists.newArrayList();
        for (ArtifactUrlClassification serviceUrlClassification : artifactsUrlClassification.getServiceUrlClassifications()) {
            this.logClassLoaderUrls("SERVICE (" + serviceUrlClassification.getArtifactId() + ")", serviceUrlClassification.getUrls());
            MuleArtifactClassLoader artifactClassLoader = new MuleArtifactClassLoader(serviceUrlClassification.getName(), new ArtifactDescriptor(serviceUrlClassification.getName()), serviceUrlClassification.getUrls().toArray(new URL[0]), parent, childClassLoaderLookupPolicy);
            servicesArtifactClassLoaders.add(artifactClassLoader);
        }
        return servicesArtifactClassLoaders;
    }

    private JarInfo getTestJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        URL testCodeUrl = artifactsUrlClassification.getTestRunnerLibUrls().get(0);
        if (!FileUtils.toFile((URL)testCodeUrl).getPath().contains("test-classes") && artifactsUrlClassification.getTestRunnerLibUrls().size() > 1) {
            testCodeUrl = artifactsUrlClassification.getTestRunnerLibUrls().get(1);
        }
        Set<String> productionPackages = this.getProductionCodePackages(testCodeUrl);
        JarInfo testJarInfo = this.getTestCodePackages(testCodeUrl);
        Set<String> testPackages = this.sanitizeTestExportedPackages(productionPackages, testJarInfo.getPackages());
        return new JarInfo(testPackages, testJarInfo.getResources(), Collections.emptyList());
    }

    private Set<String> sanitizeTestExportedPackages(Set<String> productionPackages, Set<String> testPackages) {
        TreeSet<String> sanitizedTestPackages = new TreeSet<String>(testPackages);
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, ContainerClassLoaderFactory.SYSTEM_PACKAGES);
        this.removePackagesFromTestClassLoader(sanitizedTestPackages, productionPackages);
        return sanitizedTestPackages;
    }

    private JarInfo getTestCodePackages(URL testCodeUrl) {
        ArrayList libraries = Lists.newArrayList((Object[])new URL[]{testCodeUrl});
        return this.getLibraryPackages(libraries);
    }

    private Set<String> getProductionCodePackages(URL testCodeUrl) {
        int index = testCodeUrl.toString().lastIndexOf("test-classes");
        try {
            URI productionCodeUri = new URL(testCodeUrl.toString().substring(0, index) + "classes").toURI();
            if (new File(productionCodeUri).exists()) {
                FileJarExplorer jarExplorer = new FileJarExplorer();
                return jarExplorer.explore(productionCodeUri).getPackages();
            }
            return Collections.emptySet();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void removePackagesFromTestClassLoader(Set<String> packages, Collection<String> systemPackages) {
        HashSet packagesToRemove = new HashSet();
        systemPackages.stream().forEach(systemPackage -> packages.stream().filter(p -> p.startsWith((String)systemPackage)).forEach(p -> packagesToRemove.add(p)));
        packages.removeAll(packagesToRemove);
    }

    protected ArtifactClassLoader createContainerArtifactClassLoader(TestContainerClassLoaderFactory testContainerClassLoaderFactory, ArtifactsUrlClassification artifactsUrlClassification) {
        MuleArtifactClassLoader launcherArtifact = this.createLauncherArtifactClassLoader();
        List muleModules = Collections.emptyList();
        ClassLoaderFilter filteredClassLoaderLauncher = new ContainerClassLoaderFilterFactory().create(testContainerClassLoaderFactory.getBootPackages(), muleModules);
        this.logClassLoaderUrls("CONTAINER", artifactsUrlClassification.getContainerUrls());
        ArtifactClassLoader containerClassLoader = testContainerClassLoaderFactory.createContainerClassLoader((ClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)launcherArtifact, filteredClassLoaderLauncher, Collections.emptyList()));
        return containerClassLoader;
    }

    protected MuleArtifactClassLoader createLauncherArtifactClassLoader() {
        ClassLoader launcherClassLoader = IsolatedClassLoaderFactory.class.getClassLoader();
        return new MuleArtifactClassLoader("mule", new ArtifactDescriptor("mule"), new URL[0], launcherClassLoader, (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), Collections.emptySet())){

            public URL findResource(String name) {
                URL url = super.findResource(name);
                if (url == null && this.getParent() != null) {
                    url = this.getParent().getResource(name);
                    if (url != null && url.getFile().matches(".*?\\/jre\\/lib\\/\\w+\\.jar\\!.*")) {
                        return url;
                    }
                    return null;
                }
                return url;
            }
        };
    }

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set<String> sanitizedExportedPackages = this.sanitizePluginExportedPackages(pluginUrlClassification, parentExportedPackages, childClassLoaderLookupPolicy);
        String exportedPackages = sanitizedExportedPackages.stream().collect(Collectors.joining(", "));
        String exportedResources = pluginUrlClassification.getExportedResources().stream().collect(Collectors.joining(", "));
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.classLoaderFilterFactory.create(exportedPackages, exportedResources);
        if (!pluginUrlClassification.getExportClasses().isEmpty()) {
            artifactClassLoaderFilter = new TestArtifactClassLoaderFilter(artifactClassLoaderFilter, pluginUrlClassification.getExportClasses());
        }
        return artifactClassLoaderFilter;
    }

    private Set<String> sanitizePluginExportedPackages(PluginUrlClassification pluginUrlClassification, Set<String> parentExportedPackages, ClassLoaderLookupPolicy childClassLoaderLookupPolicy) {
        Set appProvidedPackages;
        HashSet<String> exportedPackages = new HashSet<String>(pluginUrlClassification.getExportedPackages());
        Set containerProvidedPackages = exportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = childClassLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            exportedPackages.removeAll(containerProvidedPackages);
            LOGGER.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by parent class loader: " + containerProvidedPackages);
        }
        if (!(appProvidedPackages = parentExportedPackages.stream().filter(p -> exportedPackages.contains(p)).collect(Collectors.toSet())).isEmpty()) {
            exportedPackages.removeAll(appProvidedPackages);
            LOGGER.warn("Exported packages from plugin '" + pluginUrlClassification.getName() + "' are provided by the artifact owner: " + appProvidedPackages);
        }
        return exportedPackages;
    }

    protected ArtifactClassLoader createApplicationArtifactClassLoader(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification, List<ArtifactClassLoader> pluginsArtifactClassLoaders) {
        ArrayList<URL> applicationUrls = new ArrayList<URL>();
        applicationUrls.addAll(artifactsUrlClassification.getApplicationLibUrls());
        applicationUrls.addAll(artifactsUrlClassification.getApplicationSharedLibUrls());
        this.logClassLoaderUrls("APP", applicationUrls);
        ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(APP_NAME);
        return new MuleApplicationClassLoader(APP_NAME, (ArtifactDescriptor)applicationDescriptor, parent, new DefaultNativeLibraryFinderFactory().create(APP_NAME, applicationDescriptor.getLoadedNativeLibrariesFolderName(), applicationUrls.toArray(new URL[applicationUrls.size()])), applicationUrls, childClassLoaderLookupPolicy, pluginsArtifactClassLoaders);
    }

    protected void logClassLoaderUrls(String classLoaderName, List<URL> urls) {
        StringBuilder builder = new StringBuilder(classLoaderName).append(" classloader urls: [");
        urls.stream().forEach(e -> builder.append("\n").append(" ").append(e));
        builder.append("\n]");
        this.logClassLoadingTrace(builder.toString());
    }

    private void logClassLoadingTrace(String message) {
        if (this.isVerboseClassLoading().booleanValue()) {
            LOGGER.info(message);
        } else {
            LOGGER.debug(message);
        }
    }

    private Boolean isVerboseClassLoading() {
        return Boolean.valueOf(System.getProperty("mule.classloading.verbose"));
    }
}

