/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.MuleServiceModel;
import org.mule.runtime.api.deployment.persistence.MuleServiceModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.discoverer.ImmutableServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceProviderDiscoverer;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;

public class IsolatedServiceProviderDiscoverer
implements ServiceProviderDiscoverer {
    private final List<ArtifactClassLoader> serviceArtifactClassLoaders;

    public IsolatedServiceProviderDiscoverer(List<ArtifactClassLoader> serviceArtifactClassLoaders) {
        Preconditions.checkNotNull(serviceArtifactClassLoaders, (String)"serviceArtifactClassLoaders cannot be null");
        this.serviceArtifactClassLoaders = serviceArtifactClassLoaders;
    }

    public List<ServiceAssembly> discover() throws ServiceResolutionError {
        LinkedList<ServiceAssembly> locators = new LinkedList<ServiceAssembly>();
        MuleServiceModelJsonSerializer serializer = new MuleServiceModelJsonSerializer();
        for (ArtifactClassLoader serviceArtifactClassLoader : this.serviceArtifactClassLoaders) {
            try {
                MuleServiceModel serviceModel;
                ClassLoader classLoader = (ClassLoader)serviceArtifactClassLoader.getClass().getMethod("getClassLoader", new Class[0]).invoke((Object)serviceArtifactClassLoader, new Object[0]);
                try (InputStream descriptor = classLoader.getResourceAsStream("META-INF/mule-artifact/mule-artifact.json");){
                    serviceModel = (MuleServiceModel)serializer.deserialize(IOUtils.toString((InputStream)descriptor));
                }
                for (MuleServiceContractModel contract : serviceModel.getContracts()) {
                    ServiceProvider serviceProvider = this.instantiateServiceProvider(classLoader, contract.getServiceProviderClassName());
                    locators.add((ServiceAssembly)new ImmutableServiceAssembly(serviceModel.getName(), serviceProvider, classLoader, ClassUtils.loadClass((String)contract.getContractClassName(), (ClassLoader)this.getClass().getClassLoader())));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't discover service from class loader: " + serviceArtifactClassLoader, e);
            }
        }
        return locators;
    }

    private ServiceProvider instantiateServiceProvider(ClassLoader classLoader, String className) throws ServiceResolutionError {
        Object reflectedObject;
        try {
            reflectedObject = ClassUtils.withContextClassLoader((ClassLoader)classLoader, () -> {
                try {
                    return ClassUtils.instantiateClass((String)className, (Object[])new Object[0]);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Unable to create service from class: " + className)), (Throwable)e);
                }
            });
        }
        catch (RuntimeException e) {
            throw new ServiceResolutionError(e.getMessage(), (Throwable)e);
        }
        if (!(reflectedObject instanceof ServiceProvider)) {
            throw new ServiceResolutionError(String.format("Provided service class '%s' does not implement '%s'", className, ServiceProvider.class.getName()));
        }
        return (ServiceProvider)reflectedObject;
    }
}

