/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.SimpleRegistry;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.test.runner.api.ClassPathUrlProvider;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.api.ExtensionModelLoaderFinder;
import org.mule.test.runner.infrastructure.ExtensionsTestInfrastructureDiscoverer;
import org.mule.test.runner.utils.TroubleshootingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;

class ExtensionPluginMetadataGenerator {
    private static final String GENERATED_TEST_RESOURCES = "generated-test-resources";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExtensionsTestInfrastructureDiscoverer extensionsInfrastructure;
    private final File generatedResourcesBase;
    private final File extensionMulePluginJson;
    private final ExtensionModelLoaderFinder extensionModelLoaderFinder;
    private final List<ExtensionGeneratorEntry> extensionGeneratorEntries = Lists.newArrayList();

    ExtensionPluginMetadataGenerator(File baseResourcesFolder) {
        this(baseResourcesFolder, new ExtensionModelLoaderFinder());
    }

    ExtensionPluginMetadataGenerator(File baseResourcesFolder, ExtensionModelLoaderFinder loaderFinder) {
        this.extensionsInfrastructure = new ExtensionsTestInfrastructureDiscoverer(this.createExtensionManager());
        this.generatedResourcesBase = this.getGeneratedResourcesBase(baseResourcesFolder);
        this.extensionMulePluginJson = this.getExtensionMulePluginJsonFile(baseResourcesFolder);
        this.extensionModelLoaderFinder = loaderFinder;
    }

    private File getExtensionMulePluginJsonFile(File baseResourcesFolder) {
        return Paths.get(baseResourcesFolder.getPath(), "classes", "META-INF/mule-artifact.json").toFile();
    }

    private File getGeneratedResourcesBase(File baseResourcesFolder) {
        File generatedResourcesBase = new File(baseResourcesFolder, GENERATED_TEST_RESOURCES);
        generatedResourcesBase.mkdir();
        return generatedResourcesBase;
    }

    private ExtensionManager createExtensionManager() {
        DefaultExtensionManager extensionManager = new DefaultExtensionManager();
        DefaultMuleContext muleContext = new DefaultMuleContext(){
            private final ErrorTypeRepository errorTypeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();
            private final ErrorTypeLocator errorTypeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator((ErrorTypeRepository)this.errorTypeRepository);
            private final LazyValue<SimpleRegistry> registryCreator = new LazyValue(() -> {
                SimpleRegistry registry = new SimpleRegistry((MuleContext)this, (LifecycleInterceptor)new MuleLifecycleInterceptor());
                try {
                    registry.registerObject(ErrorTypeRepository.class.getName(), (Object)this.errorTypeRepository);
                    registry.registerObject(ErrorTypeLocator.class.getName(), (Object)this.errorTypeLocator);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                return registry;
            });

            public MuleRegistry getRegistry() {
                return new MuleRegistryHelper((Registry)this.registryCreator.get(), (MuleContext)this);
            }

            public Injector getInjector() {
                return (Injector)this.registryCreator.get();
            }
        };
        muleContext.setMuleConfiguration((MuleConfiguration)new DefaultMuleConfiguration());
        try {
            LifecycleUtils.initialiseIfNeeded((Object)extensionManager, (MuleContext)muleContext);
        }
        catch (InitialisationException e) {
            throw new RuntimeException("Error while initialising the extension manager", e);
        }
        return extensionManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Class scanForExtensionAnnotatedClasses(Artifact plugin, List<URL> urls) {
        URL firstURL = (URL)urls.stream().findFirst().get();
        this.logger.warn("Scanning plugin '{}' for annotated Extension class from {}", (Object)plugin, (Object)firstURL);
        this.logger.warn("Available URLS: {}", urls);
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter(new AnnotationTypeFilter(Extension.class));
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{firstURL}, null);){
            scanner.setResourceLoader(new PathMatchingResourcePatternResolver(classLoader));
            Set<BeanDefinition> extensionsAnnotatedClasses = scanner.findCandidateComponents("");
            if (!extensionsAnnotatedClasses.isEmpty()) {
                if (extensionsAnnotatedClasses.size() > 1) {
                    this.logger.warn("While scanning class loader on plugin '{}' for discovering @Extension classes annotated, more than one found. It will pick up the first one, found: {}", (Object)plugin, extensionsAnnotatedClasses);
                }
                String extensionClassName = extensionsAnnotatedClasses.iterator().next().getBeanClassName();
                try {
                    this.logger.trace("Going to load Extension class '" + extensionClassName + "' obtained from: '" + firstURL + "' using classpath: " + new ClassPathUrlProvider().getURLs());
                    Class<?> clazz = Class.forName(extensionClassName);
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    List<URL> classpath = new ClassPathUrlProvider().getURLs();
                    this.logger.warn("CLASSPATH URLs:");
                    classpath.forEach(url -> this.logger.warn(url.toString()));
                    throw new IllegalArgumentException("Cannot load Extension class '" + extensionClassName + " obtained from: '" + firstURL + "' with MD5 '" + TroubleshootingUtils.getMD5FromFile(firstURL) + "' with last modification on '" + TroubleshootingUtils.getLastModifiedDateFromUrl(firstURL) + "' using classpath: " + classpath, e);
                }
            }
            this.logger.debug("No class found annotated with {}", (Object)Extension.class.getName());
            Class clazz = null;
            return clazz;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ExtensionModel getExtensionModel(Artifact plugin, Class extensionClass, DependencyResolver dependencyResolver, List<RemoteRepository> rootArtifactRemoteRepositories) {
        ExtensionModelLoader loader = this.extensionModelLoaderFinder.findLoaderByProperty(plugin, dependencyResolver, rootArtifactRemoteRepositories).orElse(this.extensionModelLoaderFinder.findLoaderFromMulePlugin(this.extensionMulePluginJson));
        return this.extensionsInfrastructure.discoverExtension(extensionClass, loader);
    }

    File generateExtensionResources(Artifact plugin, Class extensionClass, DependencyResolver dependencyResolver, List<RemoteRepository> rootArtifactRemoteRepositories) {
        this.logger.debug("Generating Extension metadata for extension class: '{}'", (Object)extensionClass);
        ExtensionModel extensionModel = this.getExtensionModel(plugin, extensionClass, dependencyResolver, rootArtifactRemoteRepositories);
        File generatedResourcesDirectory = new File(this.generatedResourcesBase, plugin.getArtifactId() + File.separator + "META-INF");
        generatedResourcesDirectory.mkdirs();
        this.extensionsInfrastructure.generateLoaderResources(extensionModel, generatedResourcesDirectory);
        this.extensionGeneratorEntries.add(new ExtensionGeneratorEntry(extensionModel, generatedResourcesDirectory));
        return generatedResourcesDirectory.getParentFile();
    }

    class ExtensionGeneratorEntry {
        private final ExtensionModel runtimeExtensionModel;
        private final File resourcesFolder;

        ExtensionGeneratorEntry(ExtensionModel runtimeExtensionModel, File resourcesFolder) {
            this.runtimeExtensionModel = runtimeExtensionModel;
            this.resourcesFolder = resourcesFolder;
        }

        public ExtensionModel getExtensionModel() {
            return this.runtimeExtensionModel;
        }

        File getResourcesFolder() {
            return this.resourcesFolder;
        }
    }
}

