/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.execution.utils.SourcePolicyTestUtils;
import org.mule.runtime.core.internal.policy.MessageSourceResponseParametersProcessor;
import org.mule.runtime.core.internal.policy.NoSourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class NoSourcePolicyBenchmark
extends AbstractBenchmark {
    private SourcePolicy handler;
    private MessageSourceResponseParametersProcessor sourceRpp;

    @Setup(value=Level.Trial)
    public void setUp() {
        this.handler = new NoSourcePolicy(eventPub -> Flux.from((Publisher)eventPub).flatMap(e -> Mono.just((Object)e)));
        this.sourceRpp = new MessageSourceResponseParametersProcessor(){

            public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
                return event -> Collections.emptyMap();
            }

            public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
                return event -> Collections.emptyMap();
            }
        };
    }

    @Benchmark
    @Threads(value=-1)
    public Either<SourcePolicyFailureResult, SourcePolicySuccessResult> source() throws Throwable {
        Message.Builder messageBuilder = Message.builder().value((Object)PAYLOAD);
        CoreEvent.Builder eventBuilder = CoreEvent.builder((EventContext)EventContextFactory.create((String)"", (String)"", (ComponentLocation)CONNECTOR_LOCATION, null, Optional.empty())).message(messageBuilder.build());
        CoreEvent event = eventBuilder.build();
        return (Either)SourcePolicyTestUtils.block(callback -> this.handler.process(event, this.sourceRpp, callback));
    }
}

