/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.routing.Foreach;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.util.MuleContextUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Warmup(iterations=2)
@Measurement(iterations=50)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ForeachBenchmark
extends AbstractBenchmark {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForeachBenchmark.class);
    private static final int PAYLOADS = 50000;
    private static final int NESTED_PAYLOADS = 5000;
    private static final int INNER_PAYLOADS = 100;
    private static final int CONCURRENCY = 10;
    private static final int PAYLOADS_CONCURRENT = 50000;
    private static final int CONCURRENCY_TIMEOUT_SECONDS = 30;
    private ConfigurationComponentLocator configurationComponentLocator;
    private MuleContext muleContext;
    private CoreEvent singleForeachEvent;
    private CoreEvent nestedForeachEvent;
    private CoreEvent foreachEvent;
    private List<String> chainedPayloads;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        int i;
        this.configurationComponentLocator = (ConfigurationComponentLocator)Mockito.mock(ConfigurationComponentLocator.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        ArrayList<String> payload = new ArrayList<String>();
        for (int i2 = 0; i2 < 50000; ++i2) {
            payload.add("" + i2);
        }
        this.singleForeachEvent = MuleContextUtils.eventBuilder((MuleContext)this.muleContext).message(Message.of(payload)).build();
        ArrayList nestedForeachPayload = new ArrayList();
        for (i = 0; i < 5000; ++i) {
            ArrayList<String> items = new ArrayList<String>();
            for (int j = 0; j < 100; ++j) {
                items.add(i + "_" + j);
            }
            nestedForeachPayload.add(items);
        }
        this.nestedForeachEvent = MuleContextUtils.eventBuilder((MuleContext)this.muleContext).message(Message.of(nestedForeachPayload)).build();
        this.foreachEvent = MuleContextUtils.eventBuilder((MuleContext)this.muleContext).message(Message.of(Arrays.asList(1, 2, 3))).build();
        this.chainedPayloads = new ArrayList<String>();
        for (i = 0; i < 50000; ++i) {
            this.chainedPayloads.add("" + i);
        }
    }

    private Foreach createForeach() {
        Foreach foreach = new Foreach();
        foreach.setAnnotations(AbstractMuleContextTestCase.getAppleFlowComponentLocationAnnotations());
        return foreach;
    }

    @TearDown
    public void tearDown() {
        this.muleContext.dispose();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public int singleForeach() {
        AtomicInteger counter = new AtomicInteger();
        try {
            Foreach singleForeach = this.createForeach();
            Processor capturedEventProcessor = event -> {
                counter.incrementAndGet();
                return event;
            };
            singleForeach.setMessageProcessors(Collections.singletonList(capturedEventProcessor));
            LifecycleUtils.initialiseIfNeeded((Object)singleForeach, (MuleContext)this.muleContext);
            singleForeach.process(this.singleForeachEvent);
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error on singleForeach", t);
        }
        return counter.get();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public int nestedForeach() {
        AtomicInteger counter = new AtomicInteger();
        try {
            Foreach internalForeach = this.createForeach();
            Processor nestedEventProcessor = event -> {
                counter.incrementAndGet();
                return event;
            };
            internalForeach.setMessageProcessors(Collections.singletonList(nestedEventProcessor));
            Foreach nestedForeach = this.createForeach();
            nestedForeach.setMessageProcessors(Collections.singletonList(internalForeach));
            LifecycleUtils.initialiseIfNeeded((Object)nestedForeach, (MuleContext)this.muleContext);
            nestedForeach.process(this.nestedForeachEvent);
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error on nestedForeach", t);
        }
        return counter.get();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SingleShotTime})
    public int multiplesThreadsUsingSameForeach() {
        AtomicInteger counter = new AtomicInteger();
        try {
            Foreach foreach = this.createForeach();
            Processor emptyEventProcessor = event -> event;
            foreach.setMessageProcessors(Collections.singletonList(emptyEventProcessor));
            LifecycleUtils.initialiseIfNeeded((Object)foreach, (MuleContext)this.muleContext);
            CountDownLatch threadsLatch = new CountDownLatch(10);
            Latch mainThreadLatch = new Latch();
            Processor secondCapturedEventProcessor = event -> {
                counter.incrementAndGet();
                return event;
            };
            Foreach chainedForeach = this.createForeach();
            chainedForeach.setMessageProcessors(Collections.singletonList(secondCapturedEventProcessor));
            LifecycleUtils.initialiseIfNeeded((Object)chainedForeach, (MuleContext)this.muleContext);
            CoreEvent parentEvent = foreach.process(this.foreachEvent);
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            for (int t = 0; t < 10; ++t) {
                BaseEventContext childContext = MessageProcessors.newChildContext((CoreEvent)parentEvent, Optional.empty());
                CoreEvent childEvent = CoreEvent.builder((EventContext)childContext, (CoreEvent)parentEvent).message(Message.of(this.chainedPayloads)).build();
                executorService.submit(() -> {
                    try {
                        threadsLatch.countDown();
                        mainThreadLatch.await();
                        chainedForeach.process(childEvent);
                    }
                    catch (Throwable e) {
                        LOGGER.error("An unexpected error processing events", e);
                    }
                });
            }
            threadsLatch.await();
            mainThreadLatch.release();
            executorService.shutdown();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOGGER.error("Unexpected error on multiplesThreadsUsingSameForeach", t);
        }
        return counter.get();
    }

    @Override
    protected Map<String, Object> getStartUpRegistryObjects() {
        Mockito.when((Object)this.configurationComponentLocator.find((Location)ArgumentMatchers.any(Location.class))).thenReturn(Optional.empty());
        Mockito.when((Object)this.configurationComponentLocator.find((ComponentIdentifier)ArgumentMatchers.any(ComponentIdentifier.class))).thenReturn(Collections.emptyList());
        return Collections.singletonMap("_muleConfigurationComponentLocator", this.configurationComponentLocator);
    }
}

