/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import java.util.Map;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class EventBenchmark
extends AbstractBenchmark {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private MuleContext muleContext;
    private Flow flow;
    private CoreEvent event;
    private CoreEvent eventWith10VariablesProperties;
    private CoreEvent eventWith50VariablesProperties;
    private CoreEvent eventWith100VariablesProperties;

    @Setup
    public void setup() throws Exception {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        this.flow = this.createFlow(this.muleContext);
        LegacyRegistryUtils.registerObject((MuleContext)this.muleContext, (String)"flow", (Object)this.flow, FlowConstruct.class);
        Message.Builder messageBuilder = Message.builder().value((Object)PAYLOAD);
        CoreEvent.Builder eventBuilder = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(messageBuilder.build());
        this.event = eventBuilder.build();
        this.eventWith10VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(10);
        this.eventWith50VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(50);
        this.eventWith100VariablesProperties = this.createMuleEventWithFlowVarsAndProperties(50);
    }

    @TearDown
    public void teardown() throws MuleException {
        this.muleContext.stop();
        LifecycleUtils.stopIfNeeded((Object)LegacyRegistryUtils.lookupObject((MuleContext)this.muleContext, SchedulerService.class));
        this.muleContext.dispose();
    }

    @Benchmark
    public CoreEvent createEvent() {
        return CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(Message.of((Object)PAYLOAD)).build();
    }

    @Benchmark
    public CoreEvent copyEvent() {
        return CoreEvent.builder((CoreEvent)this.event).build();
    }

    @Benchmark
    public CoreEvent copyEventWith20VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith10VariablesProperties).build();
    }

    @Benchmark
    public CoreEvent copyEventWith100VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith100VariablesProperties).build();
    }

    @Benchmark
    public CoreEvent deepCopyEvent() {
        return CoreEvent.builder((CoreEvent)this.event).message(Message.builder((Message)this.event.getMessage()).build()).build();
    }

    @Benchmark
    public CoreEvent deepCopyEventWith20VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith10VariablesProperties).message(Message.builder((Message)this.eventWith10VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public CoreEvent deepCopyEventWith50VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith50VariablesProperties).message(Message.builder((Message)this.eventWith50VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public CoreEvent deepCopyEventWith100VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith100VariablesProperties).message(Message.builder((Message)this.eventWith100VariablesProperties.getMessage()).build()).build();
    }

    @Benchmark
    public CoreEvent addEventVariable() {
        return CoreEvent.builder((CoreEvent)this.event).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public CoreEvent addEventVariableEventWith20VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith10VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public CoreEvent addEventVariableEventWith50VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith50VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public CoreEvent addEventVariableEventWith100VariablesProperties() {
        return CoreEvent.builder((CoreEvent)this.eventWith100VariablesProperties).addVariable(KEY, (Object)VALUE).build();
    }

    @Benchmark
    public CoreEvent copyWith10FlowVarsAnd10PropertiesWrite1OfEach() throws Exception {
        return PrivilegedEvent.builder((CoreEvent)this.eventWith10VariablesProperties).session((MuleSession)new DefaultMuleSession(((PrivilegedEvent)this.eventWith10VariablesProperties).getSession())).addVariable("newKey", (Object)"val").message((Message)InternalMessage.builder((Message)this.eventWith10VariablesProperties.getMessage()).addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build()).build();
    }

    @Benchmark
    public CoreEvent copyWith10FlowVarsAnd10PropertiesWrite5OfEach() throws Exception {
        PrivilegedEvent.Builder eventBuilder = PrivilegedEvent.builder((CoreEvent)this.eventWith50VariablesProperties);
        eventBuilder.session((MuleSession)new DefaultMuleSession(((PrivilegedEvent)this.eventWith50VariablesProperties).getSession())).build();
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.eventWith50VariablesProperties.getMessage());
        for (int j = 1; j <= 5; ++j) {
            eventBuilder.addVariable("newKey" + j, (Object)"val");
            builder.addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build();
        }
        return eventBuilder.message((Message)builder.build()).build();
    }

    @Benchmark
    public CoreEvent copyWith50FlowVarsAnd50PropertiesWrite1OfEach() throws Exception {
        return PrivilegedEvent.builder((CoreEvent)this.eventWith50VariablesProperties).session((MuleSession)new DefaultMuleSession(((PrivilegedEvent)this.eventWith50VariablesProperties).getSession())).addVariable("newKey", (Object)"val").message((Message)InternalMessage.builder((Message)this.eventWith50VariablesProperties.getMessage()).addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build()).build();
    }

    @Benchmark
    public CoreEvent copyWith100FlowVarsAndPropertiesWrite25OfEach() throws Exception {
        PrivilegedEvent.Builder eventBuilder = PrivilegedEvent.builder((CoreEvent)this.eventWith100VariablesProperties);
        eventBuilder.session((MuleSession)new DefaultMuleSession(((PrivilegedEvent)this.eventWith100VariablesProperties).getSession())).build();
        InternalMessage.Builder builder = InternalMessage.builder((Message)this.eventWith100VariablesProperties.getMessage());
        for (int j = 1; j <= 25; ++j) {
            eventBuilder.addVariable("newKey" + j, (Object)"val");
            builder.addInboundProperty("newKey", (Serializable)((Object)"val")).addOutboundProperty("newKey", (Serializable)((Object)"val")).build();
        }
        return eventBuilder.message((Message)builder.build()).build();
    }

    @Benchmark
    public CoreEvent quickCopyInternalParameters() {
        return InternalEvent.builder((CoreEvent)EventQuickCopy.quickCopy((CoreEvent)EventQuickCopy.quickCopy((CoreEvent)this.event, (Map)SmallMap.of((Object)"k1", (Object)"v1")), (Map)SmallMap.of((Object)"k2", (Object)"v2"))).addInternalParameter("k3", (Object)"v3").build();
    }

    private CoreEvent createMuleEvent(Message message, int numProperties) {
        CoreEvent.Builder builder;
        try {
            builder = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(message);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int i = 1; i <= numProperties; ++i) {
            builder.addVariable("FlOwVaRiAbLeKeY" + i, (Object)"val");
        }
        return builder.build();
    }

    private CoreEvent createMuleEventWithFlowVarsAndProperties(int numProperties) {
        InternalMessage.Builder builder = InternalMessage.builder().value((Object)PAYLOAD);
        for (int i = 1; i <= numProperties; ++i) {
            builder.addInboundProperty("InBoUnDpRoPeRtYkEy" + i, (Serializable)((Object)"val"));
        }
        InternalMessage message = builder.build();
        CoreEvent event = this.createMuleEvent((Message)message, numProperties);
        return event;
    }
}

