/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import org.databene.contiperf.PerfTest;
import org.databene.contiperf.junit.ContiPerfRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.IOUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class MuleEventCopyPerformanceTestCase
extends AbstractMuleContextTestCase {
    @Rule
    public ContiPerfRule rule = new ContiPerfRule();
    @Mock
    private Flow flow;
    private String payload;
    private DefaultMuleEvent event;

    public int getTestTimeoutSecs() {
        return 120;
    }

    @Before
    public void before() throws IOException {
        this.payload = IOUtils.getResourceAsString((String)"test-data.json", ((Object)((Object)this)).getClass());
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copy() throws Exception {
        this.event = this.createMuleEvent();
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)this.event.newThreadCopy();
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith10FlowVarsAnd10Properties() throws Exception {
        this.event = this.createMuleEventWithFlowVarsAndProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)this.event.newThreadCopy();
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith50FlowVarsAnd50Properties() throws Exception {
        this.event = this.createMuleEventWithFlowVarsAndProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)this.event.newThreadCopy();
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith10FlowVarsAnd10PopertiesWrite1OfEach() throws Exception {
        this.event = this.createMuleEventWithFlowVarsAndProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)this.event.newThreadCopy();
            this.event.setFlowVariable("newKey", (Object)"val");
            this.event.getMessage().setOutboundProperty("newKey", (Object)"val");
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith10FlowVarsAnd10PopertiesWrite5OfEach() throws Exception {
        DefaultMuleEvent original = this.createMuleEventWithFlowVarsAndProperties(10);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)original.newThreadCopy();
            for (int j = 1; j <= 5; ++j) {
                this.event.setFlowVariable("newKey" + j, (Object)"val");
                this.event.getMessage().setOutboundProperty("newKey" + j, (Object)"val");
            }
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith50FlowVarsAnd50PropertiesWrite1OfEach() throws Exception {
        DefaultMuleEvent original = this.createMuleEventWithFlowVarsAndProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)original.newThreadCopy();
            this.event.setFlowVariable("newKey", (Object)"val");
            this.event.getMessage().setOutboundProperty("newKey", (Object)"val");
        }
    }

    @Test
    @PerfTest(duration=15000, threads=1, warmUp=5000)
    public void copyWith100FlowVarsAndPropertiesWrite25OfEach() throws Exception {
        DefaultMuleEvent original = this.createMuleEventWithFlowVarsAndProperties(50);
        for (int i = 0; i < 1000; ++i) {
            this.event = (DefaultMuleEvent)original.newThreadCopy();
            for (int j = 1; j <= 25; ++j) {
                this.event.setFlowVariable("newKey" + j, (Object)"val");
                this.event.getMessage().setOutboundProperty("newKey" + j, (Object)"val");
            }
        }
    }

    protected DefaultMuleEvent createMuleEvent() throws Exception {
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)this.payload, muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
    }

    protected DefaultMuleEvent createMuleEventWithFlowVarsAndProperties(int numProperties) throws Exception {
        DefaultMuleEvent event = this.createMuleEvent();
        for (int i = 1; i <= numProperties; ++i) {
            event.setFlowVariable("InBoUnDpRoPeRtYkEy" + i, (Object)"val");
            event.getMessage().setOutboundProperty("InBoUnDpRoPeRtYkEy" + i, (Object)"val");
        }
        return event;
    }
}

